/********** MOP03Metadata.C *************************************************************************************\

 $Header$

 REVISION HISTORY
   03/03   Debbie Mao

 $Log$ 

\**********************************************************************************************************************/
#include "MOP03Metadata.h"
#include "DiagnosticReporter.h"
#include "Driver.h"

extern diagnostic_reporter diagnosticreporter;

mop03_metadata :: mop03_metadata ()
{
  ;
}


mop03_metadata :: ~mop03_metadata ()
{
  PGS_MET_Remove ();
}

bool mop03_metadata :: Initialize ()
{
  bool isinit = false;

  // make sure logical is not invalid
  if (MOP03_MCF_LOGICAL == 0)
    diagnosticreporter.Write (DIAGNOSTICS_WARNING, 300, "Could not initialize metadata without a logical");

  if (PGS_MET_Init (MOP03_MCF_LOGICAL, handles) != PGS_S_SUCCESS)
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 302,"Could not initialize metadata");

  isinit = true;
  return isinit;
}

bool mop03_metadata :: Set (double starttime, double stoptime )
{
  bool isset = false;

  if ( Initialize() ) {
    if (inputgranule.Set (handles [INVENTORYMETADATA]) )
      if ( ecsdatagranule.Set (handles [INVENTORYMETADATA]) )
	if (pgeversionclass.Set (handles [INVENTORYMETADATA]) )
	  if (rangedatetime.Set (handles [INVENTORYMETADATA], starttime, stoptime))
	    if (carbonmonoxide.Set (handles [INVENTORYMETADATA], "Carbon Monoxide", 1 ))
	      isset = true;
  }
  return isset;
}

void mop03_metadata :: Write ( double starttime, double stoptime, int32 metadataid) 
{
  PGSt_integer mid;
  PGSt_SMF_status status;
  char msg[PGS_SMF_MAX_MSG_SIZE];
  char err[PGS_SMF_MAX_MNEMONIC_SIZE];
  PGSt_integer version = 1;
  char filename [PGSd_PC_FILE_PATH_MAX]="";

  if ( Set ( starttime, stoptime) ) {

    if (PGS_PC_GetReference (M3LOGICAL, &version, filename) != PGS_S_SUCCESS)
      diagnosticreporter.Write (DIAGNOSTICS_ERROR, 303, "Could not get MOP03 filename");

    status=PGS_MET_SDstart (filename, HE5F_ACC_RDWR, &mid);
    if (status != PGS_S_SUCCESS) {
      PGS_SMF_GetMsg(&status, err, msg);
      diagnosticreporter.Write (DIAGNOSTICS_ERROR, 304, msg);
    }

    if (PGS_MET_Write (handles [INVENTORYMETADATA], (char*) "coremetadata.0", mid) != PGS_S_SUCCESS) {
      char idvalues [20];
      (void) sprintf (idvalues, "%d", mid);
      string message = "Could not write coremetadata.0 using id ";
      message += idvalues;
      diagnosticreporter.Write (DIAGNOSTICS_ERROR, 305, message);
    }
  }
}
  
