/************************ MOP02_Read_Dat2.C ***************************************************************************\

 PURPOSE
   To read data from MOP02.he5

 REVISION HISTORY
   03/13   Debbie Mao

\**********************************************************************************************************************/
#include "MOP02.h"
#include "DiagnosticReporter.h"
#include <string>

extern diagnostic_reporter diagnosticreporter;

using namespace std;


bool MOP02_Read_Dat2(int fil, MOP02_Geo &Geo, MOP02_Dat2 &Dat2)
{
  intn     errstat;
  hid_t    fileid, swid;
  int      ierr, nt;
  hssize_t start1[1], start2[2], start3[3];
  hsize_t  edge1[1], edge2[2], edge3[3];
  char   filename [PGSd_PC_FILE_PATH_MAX];
  PGSt_integer version = 1;
  bool isread = false;


  // initialize all the variables
  for ( int t = 0; t < NTIME; t++) {
    Geo.lat[t] = MISSING_VALUE;
    Geo.lon[t] = MISSING_VALUE;
    Geo.solzen[t] = MISSING_VALUE;
    Geo.presurf[t]= MISSING_VALUE;
    Geo.indsurf[t]= MISSING_INT;
    Dat2.demalt[t] = MISSING_VALUE;
    Dat2.chi2[t]   = MISSING_VALUE;

    for ( int n = 0; n < NTWO; n++) {
      Dat2.tsurf[t][n]  = MISSING_VALUE;
      Dat2.esurf[t][n]  = MISSING_VALUE;
      Dat2.cosurf[t][n] = MISSING_VALUE;
      Dat2.cotot[t][n]  = MISSING_VALUE;
      for ( int np1 = 0; np1 < Prs; np1++){
	Dat2.comix[t][np1][n] = MISSING_VALUE;
      }
    }
  }
  version = fil + 1;

  // read the MOP02 file name
  if (PGS_PC_GetReference (M2LOGICAL, &version, filename) != PGS_S_SUCCESS) {
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 200, "Could not get MOP02 filename");
    return isread;
  }

  // open MOP02 file 
  if ((fileid = HE5_SWopen ((char*) filename, DFACC_RDONLY)) == FAIL) {
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 202, "Could not open MOP02 file");
    return isread;
  }

  // read Time Count
  errstat = HE5_EHreadglbattr(fileid, "TimeCount", (VOIDP) &Geo.timecount);	
  if (errstat == FAIL || Geo.timecount < (int32) 1){
    (void) HE5_SWclose (fileid);
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 204, "Could not read time count from MOP02 file");
    return isread;
  }

  // attach swath
  swid = HE5_SWattach (fileid, "MOP02");
  if (swid < (int32) 0) {
    (void) HE5_SWclose (fileid);
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 204, "Could not attach MOP02 file");
    return isread;
  }


  start1[0] = 0;   
  edge1 [0] = Geo.timecount;

  // read latitude [NTIME]
  ierr = HE5_SWreadfield(swid,"Latitude",start1, NULL,edge1, (VOIDP)Geo.lat);
  if ( ierr != 0 )
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 308, "Could not read Latitude" );
  
  // read longitude [NTIME]
  ierr = HE5_SWreadfield(swid,"Longitude",start1, NULL,edge1, (VOIDP)Geo.lon);
  if ( ierr != 0 )
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 310, "Could not read Longitude" );
  
  // read Solar Zenith Angle [NTIME]
  ierr = HE5_SWreadfield(swid,"SolarZenithAngle",start1, NULL,edge1, (VOIDP)Geo.solzen);
  if ( ierr != 0 )
    diagnosticreporter.Write (DIAGNOSTICS_ERROR,312, "Could not read Solar Zenith Angle" );

  // read Surface Index [NTIME]
  ierr = HE5_SWreadfield(swid,"SurfaceIndex",start1, NULL,edge1, (VOIDP)Geo.indsurf);
  if ( ierr != 0 )
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 314, "Could not read Surface Index" );

  // read Surface Pressure  [NTIME][0]
  start2[0] = 0;                start2[1] = 0;
  edge2 [0] = Geo.timecount;    edge2 [1] = 1;   
  ierr = HE5_SWreadfield(swid,"SurfacePressure",start2, NULL,edge2, (VOIDP)Geo.presurf) ;
  if ( ierr != 0 )
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 320, "Could not read Surface Pressure" );

  // read DEM altitude [NTIME]
  ierr = HE5_SWreadfield(swid,"DEMAltitude",start1, NULL,edge1, (VOIDP)Dat2.demalt);
  if ( ierr != 0 )
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 316, "Could not read DEM Altitude" );

  // read Signal Chi2 [NTIME]
  ierr = HE5_SWreadfield(swid,"SignalChi2",start1, NULL,edge1, (VOIDP)Dat2.chi2);
  if ( ierr != 0 ) {
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 219, "Could not read Signal Chi2" );
    return isread;
  }

  start2[0] = 0;                start2[1] = 0;
  edge2 [0] = Geo.timecount;    edge2 [1] = NTWO; 

  // read Retrieved Surface Temperature  [NTWO][NTIME]
  ierr = HE5_SWreadfield(swid,"RetrievedSurfaceTemperature",start2, NULL,edge2, (VOIDP)Dat2.tsurf) ;
  if ( ierr != 0 ) {
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 219, "Could not read Retrieved Surface Temperature");
    return isread;
  }
  
  // read Retrieved Surface Emissivity  [NTWO][NTIME]
  ierr = HE5_SWreadfield(swid,"RetrievedSurfaceEmissivity",start2, NULL,edge2, (VOIDP)Dat2.esurf) ;
  if ( ierr != 0 ) {
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 220, "Could not read Retrieved Surface Emissivity");
    return isread;
  }
 
  // read Retrieved CO Total Column Data [NTWO][NTIME]
  ierr = HE5_SWreadfield(swid,"RetrievedCOTotalColumn",start2, NULL,edge2, (VOIDP)Dat2.cotot) ;
  if ( ierr != 0 ) {
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 221, "Could not read Retrieved CO Total Column" );
    return isread;
  }

  // read Retrieved CO Surface Mixing Ratio [NTWO][NTIME]
  ierr = HE5_SWreadfield(swid,"RetrievedCOSurfaceMixingRatio",start2, NULL,edge2, (VOIDP)Dat2.cosurf) ;
  if ( ierr != 0 ) {
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 223, "Could not read Retrieved CO Surface Mixing Ratio");
    return isread;
  }


  start3[0] = 0;                start3[1] = 0;       start3[2] = 0;
  edge3 [0] = Geo.timecount;    edge3 [1] = Prs;    edge3 [2] = NTWO;

  // read Retrieved CO Mixing Ratio Profile [NTIME][Prs][NTWO]
  ierr = HE5_SWreadfield(swid,"RetrievedCOMixingRatioProfile",start3, NULL,edge3, (VOIDP)Dat2.comix) ;
  if ( ierr != 0 ) {
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 225, "Could not read Retrieved CO Mixing Ratio Profile" );
    return isread;
  } 


  (void) HE5_SWdetach (swid); 
  (void) HE5_SWclose(fileid);

  isread = true;
  return isread;

}
