/************************ MOP02_Get_Num.C *************************************************************************\

 PURPOSE
   To get majority psurf isurf at ix/ilon

 REVISION HISTORY
   02/09   Debbie Mao

\**********************************************************************************************************************/
#include "MOP02.h"
#include <stdlib.h>


void MOP02_Get_Num (int f, MOP02_Geo Geo, MOP02_Num &Num)
{
  int d, i, j, ix, iy, dn;

  // initialize psurf and isurf
  if ( f == 0 ) {
    for ( d = 0; d < DAY; d++ ) 
      for ( i = 0; i < XDim; i++ )
	for ( j = 0; j < YDim; j++ ) {
	  Num.np6[d][i][j]  = 0;
	  Num.np7[d][i][j]  = 0;
	  Num.np8[d][i][j]  = 0;
	  Num.np9[d][i][j]  = 0;
	  Num.np10[d][i][j] = 0;
	  Num.ni0[d][i][j]  = 0;
	  Num.ni1[d][i][j]  = 0;
	  Num.ni2[d][i][j]  = 0;
	}
  }
  
  // pixel to grid lat:0-180, lon:0-360
  for (i = 0; i< Geo.timecount; i++ ) {

    if ( Geo.lat[i] > 0 )
      iy = (int) ( ( (int)Geo.lat[i] + 90 ) / YBIN );
    else
      iy = (int) ( ( (int)Geo.lat[i] + 89 ) / YBIN );
    if ( Geo.lon[i] > 0 )
      ix = (int) ( ( (int)Geo.lon[i] + 180 ) / XBIN );
    else
      ix = (int) ( ( (int)Geo.lon[i] + 179 ) / XBIN );
    if ( ix == 360 ) ix = 359;
    if ( iy == 180 ) iy = 179;

    // set up day / night flag
    if ( Geo.solzen[i] < NIGHT ) 
      dn = 0;
    else 
      dn = 1;

    // get the pixel number for each valid levels with surface pressure
    if( Geo.presurf[i]>900.0) 
      Num.np10[dn][ix][iy] += 1;
    else if( Geo.presurf[i]> 800.0) 
      Num.np9[dn][ix][iy] += 1;
    else if( Geo.presurf[i]> 700.0) 
      Num.np8[dn][ix][iy] += 1;
    else if( Geo.presurf[i]> 600.0) 
      Num.np7[dn][ix][iy] += 1;
    else if( Geo.presurf[i]> 500.0) 
      Num.np6[dn][ix][iy] += 1;
    
    // get the pixel number for each kind of surface index:  0, 1, 2 and 3 for day / night
    if ( Geo.indsurf[i] == 0 )
      Num.ni0[dn][ix][iy] += 1;
    else if (Geo.indsurf[i] == 1 ) 
      Num.ni1[dn][ix][iy] += 1;
    else if (Geo.indsurf[i] == 2) 
      Num.ni2[dn][ix][iy] += 1;
  }
}
