/********** PGEVersionClass.C *****************************************************************************************\

 $Header$

 REVISION HISTORY
   03/03   Debbie Mao

 $Log$

\**********************************************************************************************************************/
#include "PGEVersionClass.h"
#include "DiagnosticReporter.h"
#include "Driver.h"

extern diagnostic_reporter diagnosticreporter;

pge_version_class :: pge_version_class ()
                   : attribute_group ()
{
  pgeversion [0] = '\0';
}


pge_version_class :: ~pge_version_class ()
{
  ;
}


void pge_version_class :: ExtractVersion (char fullname [], char extracted []) const
{
  // save the full name (so it wont get mangled)
  char newfullname [PGSd_PC_FILE_PATH_MAX];
  char filename [PGSd_PC_FILE_PATH_MAX];
  (void) strcpy (newfullname, fullname);

  // recover the filename by parsing the full name with '/' as a token delimiter
  char* token = strtok (newfullname, "/");
  (void) strcpy (filename, token);
  while ((token = strtok (NULL, "/")) != NULL) {
    (void) strcpy (filename, token);
  }

  // extract the version info
  char* version = strstr (filename, "L3V");
  token = strtok (version, "V");
  token = strtok (NULL, "");
  (void) strncpy (extracted, token, strlen (token) - 4);
  extracted [strlen (token) - 4] = '\0';
}


bool pge_version_class :: Set (PGSt_MET_handle handle)
{
  bool isset = false;

  // get the filename from the filelogical
  PGSt_integer version = 1;
  char fullname [PGSd_PC_FILE_PATH_MAX];
  char extracted [PGSd_PC_FILE_PATH_MAX];
  if (PGS_PC_GetReference (M3LOGICAL, &version, fullname) != PGS_S_SUCCESS)
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 850, "Could not get filename");

  char* sptr = extracted;
  ExtractVersion (fullname, extracted);
  if (attribute_group::Set (handle, "PGEVersion", (void*) &sptr))
    isset = true;

  return isset;
}
