/********** InputGranule.C ********************************************************************************************\

 $Header$

 REVISION HISTORY
   03/03   Debbie Mao
   06/04   Debbie Mao -- add another input file: dem_latlon.dat

 $Log$

\**********************************************************************************************************************/
#include "InputGranule.h"
#include "Driver.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const INPUT_FILE_NUMBER = 1;

input_granule :: input_granule ()
               : attribute_group ()
{
  inputpointer = NULL;
}


input_granule :: ~input_granule ()
{
  ;
}


bool input_granule :: Set (PGSt_MET_handle handle)
{
  bool isset = false;

  // make room for the input pointers
  inputpointer = new input_pointer [INPUT_FILE_NUMBER + 1];

  // make room for pointers to the input pointers
  char** inputpointerpointers = new char* [INPUT_FILE_NUMBER + 1];

  // loop over the number of logicals
  PGSt_integer version = 1;
  char physical_filename[PGSd_PC_FILE_PATH_MAX];

  if ((PGS_PC_GetReference (M2LOGICAL, &version, physical_filename )) != PGS_S_SUCCESS)
    diagnosticreporter.Write (DIAGNOSTICS_ERROR, 830, "Could not Get MOP02 Reference");
  (void) strcpy (inputpointer [0],physical_filename );

  // the last input pointer must always be NULL
  (void) strcpy (inputpointer [INPUT_FILE_NUMBER], "\0");

  // set the pointer pointers to the pointers
  for (int pointernumber = 0; pointernumber <= INPUT_FILE_NUMBER; pointernumber++)
    inputpointerpointers [pointernumber] = (char*) inputpointer [pointernumber];

  // store the values
  isset = attribute_group::Set (handle, "InputPointer", (void*) inputpointerpointers);
  
  // delete the memory used
  delete [] inputpointer;
  delete [] inputpointerpointers;

  // return the status
  return isset;
}
