/************************ Var_Grid.C *******************************************************************************\

 PURPOSE
   To get variability for 1x1 degree grid

 REVISION HISTORY
   02/09   Debbie Mao

\**********************************************************************************************************************/
#include "Grid.h"
#include "DiagnosticReporter.h"
#include <stdlib.h>

extern diagnostic_reporter diagnosticreporter;


void  Var_Grid ( MOP03_Num Num3, Product &Prod)
{

  int d, r, k, ix, iy;

  // Step #3: 2/2 final action for L3 variability
  for ( d = 0; d < DAY; d++ )
    for ( ix = 0; ix < XDim; ix++ ) 
      for ( iy = 0; iy < YDim; iy++) {

	// surface tempressure
	if ( Num3.ntsurf[d][0][ix][iy] > NLIMIT )
	  Prod.tsurf[d][2][ix][iy] = sqrtf(Prod.tsurf[d][2][ix][iy] / Num3.ntsurf[d][0][ix][iy]);
	else 
	  Prod.tsurf[d][2][ix][iy] = MISSING_VALUE;

	// surface emissivity
	if ( Num3.nesurf[d][0][ix][iy] > NLIMIT )
	  Prod.esurf[d][2][ix][iy] = sqrtf(Prod.esurf[d][2][ix][iy] / Num3.nesurf[d][0][ix][iy]);
	else 
	  Prod.esurf[d][2][ix][iy] = MISSING_VALUE;

	// co total colomn
	if ( Prod.nco_colm[d][ix][iy] > NLIMIT )
	  Prod.co_colm[d][2][ix][iy] = sqrtf(Prod.co_colm[d][2][ix][iy] / Prod.nco_colm[d][ix][iy]) * exp(18.0);
	else 
	  Prod.co_colm[d][2][ix][iy] = MISSING_VALUE;

	// CO surface mixing ratio
	if ( Num3.nco_surf [d][ix][iy] > NLIMIT && Prod.co_surf[d][0][ix][iy] > COLIMIT ) {
	  Prod.co_surf[d][2][ix][iy] = sqrtf(Prod.co_surf[d][2][ix][iy] / Num3.nco_surf[d][ix][iy]);
	  Prod.co_surf[d][0][ix][iy] = powf(10,Prod.co_surf[d][0][ix][iy]);
	  Prod.co_surf[d][1][ix][iy] = Prod.co_surf[d][0][ix][iy] * Prod.co_surf[d][1][ix][iy];
	  Prod.co_surf[d][2][ix][iy] = Prod.co_surf[d][0][ix][iy] * Prod.co_surf[d][2][ix][iy] / LOG10E;
	}
	else 
	  for ( r = 0; r < NTHREE; r++ ) 	    
	    Prod.co_surf[d][r][ix][iy] = MISSING_VALUE;

	// co mixing ratio
	for ( k = 0; k < Prs; k++) {
	  if ( Num3.nco_mix[d][ix][iy][k] > NLIMIT && Prod.co_mix[d][0][ix][iy][k] > COLIMIT ) {
	    Prod.co_mix[d][2][ix][iy][k]=sqrtf(Prod.co_mix[d][2][ix][iy][k] / Num3.nco_mix[d][ix][iy][k]);
	    Prod.co_mix[d][0][ix][iy][k]=powf(10,Prod.co_mix[d][0][ix][iy][k]);
	    Prod.co_mix[d][1][ix][iy][k]=Prod.co_mix[d][0][ix][iy][k] * Prod.co_mix[d][1][ix][iy][k];
	    Prod.co_mix[d][2][ix][iy][k]=Prod.co_mix[d][0][ix][iy][k] * Prod.co_mix[d][2][ix][iy][k]/LOG10E;
	    }
	  else
	    for ( r = 0; r < NTHREE; r++ ) 	    
	      Prod.co_mix[d][r][ix][iy][k] = MISSING_VALUE;	
	}

	// DEM Altitude
	if ( Num3.nalt[d][ix][iy] > NLIMIT )
	  Prod.alt[d][1][ix][iy] = sqrtf(Prod.alt[d][1][ix][iy] / Num3.nalt[d][ix][iy]);
	else 
	  Prod.alt[d][1][ix][iy] = MISSING_VALUE;

	// Chi2
	if ( Num3.nchi[d][ix][iy] > NLIMIT )
	  Prod.chi[d][1][ix][iy] = sqrtf(Prod.chi[d][1][ix][iy] / Num3.nchi[d][ix][iy]);
	else 
	  Prod.chi[d][1][ix][iy] = MISSING_VALUE;
      } 
}
