/************************ PixeltoGrid.C *******************************************************************************\

 PURPOSE
   To put pixel data into 1x1 degree grid

 REVISION HISTORY
   12/02   Debbie Mao
   01/03   Debbie Mao -- change the mop03 file from Grid to Swath
   07/03   Debbie Mao -- only take data from the points with valid avgker to MOP03 file
   03/04   Debbie Mao -- change the format to pure grid and add surface indicator
   03/05   Debbie Mao -- keep the dominated surface indicator pixels in the grid
   02/09   Debbie Mao -- match V4 new L2 & L3 daily fields

\**********************************************************************************************************************/
#include "Grid.h"
#include "DiagnosticReporter.h"
#include <stdlib.h>

extern diagnostic_reporter diagnosticreporter;

void PixeltoGrid (int rmPix, int fil, float psurfmaj[DAY][XDim][YDim], MOP02_Geo Geo, MOP02_Dat1 Dat1, 
		  MOP02_Dat2 Dat2, MOP03_Num &Num3, Product &Prod )
{
  int d, t, r, i, j, k, k2, ix, iy, dn;
  int rmflag;
  float snr5, snr6;

  // initialize co data and the numbers
  if ( fil == 0 ) {
    for ( d = 0; d < DAY; d++ )
      for ( i = 0; i < XDim; i++ )
	for ( j = 0; j < YDim; j++ ) {

	  Prod.zensol[d][i][j]  = 0.0;
	  Num3.nzensol[d][i][j] = 0;
	  Prod.zensat[d][i][j]  = 0.0;
	  Num3.nzensat[d][i][j] = 0;
	  Prod.psurf[d][i][j]   = 0.0;
	  Num3.npsurf[d][i][j]  = 0;
	  Num3.nco_surf [d][i][j]    = 0;
	  Prod.ap_tsurf [d][i][j]    = 0.0;
	  Num3.nap_tsurf [d][i][j]   = 0;
	  Prod.ap_esurf [d][i][j]    = 0.0;
	  Num3.nap_esurf [d][i][j]   = 0;
	  Prod.ap_co_surf [d][i][j]  = 0.0;
	  Num3.nap_co_surf [d][i][j] = 0;
	  Prod.ap_co_tot [d][i][j]   = 0.0;
	  Num3.nap_co_tot [d][i][j]  = 0;
	  Prod.DFS [d][i][j]  = 0.0;
	  Num3.nDFS [d][i][j] = 0;
	  Num3.nalt [d][i][j]  = 0;
	  Num3.nchi [d][i][j]  = 0;
	  Prod.da_col[d][i][j] = 0.0;
	  Num3.ndry[d][i][j]   = 0;
	  Prod.wa_col[d][i][j] = 0.0;
	  Num3.nvap[d][i][j]   = 0;

	  for ( k = 0; k < Prs; k++) {
	    Num3.nco_mix[d][i][j][k]    = 0;  
	    Prod.ap_co_mix[d][i][j][k]  = 0.0;
	    Num3.nap_co_mix[d][i][j][k] = 0;
	  }
	  
	  for ( t = 0; t < NTWO; t++ ) {
	    Num3.ntsurf [d][t][i][j]    = 0;
	    Num3.nesurf [d][t][i][j]    = 0;
	    Num3.nco_totmp [d][t][i][j] = 0;
	    Num3.nco_diag [d][i][j][t]  = 0;
	    Prod.alt [d][t][i][j] = 0.0;
	    Prod.chi [d][t][i][j] = 0.0;
	    Prod.co_colm_diag [d][i][j][t] = 0.0;

	  }

	  for ( r = 0; r < NTHREE; r++ ) {
	    Prod.tsurf  [d][r][i][j]  = 0.0;
	    Prod.esurf  [d][r][i][j]  = 0.0;
	    Prod.co_colm [d][r][i][j] = 0.0;
	    Prod.co_surf [d][r][i][j] = 0.0;
	    for ( k = 0; k < Prs; k++) {
	      Prod.co_mix [d][r][i][j][k] = 0.0;
	    }
	  }
	  for ( k = 0; k < Prs1; k++)  {
	    Prod.ak_col[d][i][j][k] = 0.0;
	    Num3.nakt[d][i][j][k]   = 0;
	    for ( k2 = 0; k2 < Prs2; k2++) {
	      Prod.avgker[d][i][j][k][k2]  = 0.0;
	      Num3.navgker[d][i][j][k][k2] = 0;
	      Prod.me_cov[d][i][j][k][k2]  = 0.0;
	      Num3.nmcov[d][i][j][k][k2]   = 0;
	      Prod.sm_cov[d][i][j][k][k2]  = 0.0;
	      Num3.nscov[d][i][j][k][k2]   = 0;
	      Prod.re_cov[d][i][j][k][k2]  = 0.0;
	      Num3.nrcov[d][i][j][k][k2]   = 0;
	    }
	  }
	}
  }
  

  // add up all pixels to the grid 
  for (i = 0; i< Geo.timecount; i++ ) {

    // set up day / night flag
    if ( Geo.solzen[i] < NIGHT ) 
      dn = 0;
    else 
      dn = 1;

    // grid index lat:0-180, lon:0-360 -> SW corner
    if ( Geo.lat[i] > 0 ) 
      iy = (int) ( ( (int)Geo.lat[i] + 90 ) / YBIN );
    else 
      iy = (int) ( ( (int)Geo.lat[i] + 89 ) / YBIN );
    if ( Geo.lon[i] > 0 ) 
      ix = (int) ( ( (int)Geo.lon[i] + 180 ) / XBIN );
    else 
      ix = (int) ( ( (int)Geo.lon[i] + 179 ) / XBIN );
    if ( ix == 360 ) ix = 359;
    if ( iy == 180 ) iy = 179;

    // set up rmPix flag 0-keep, 1-TIR, 2-NIR, 3-JNT
    rmflag = 0;

    //make sure tha data are at the same level with the majority presure level
    if( (psurfmaj[dn][ix][iy] == PSURF500 && (Geo.presurf[i]>500. && Geo.presurf[i]<=600.)) ||
        (psurfmaj[dn][ix][iy] == PSURF600 && (Geo.presurf[i]>600. && Geo.presurf[i]<=700.)) ||
        (psurfmaj[dn][ix][iy] == PSURF700 && (Geo.presurf[i]>700. && Geo.presurf[i]<=800.)) ||
        (psurfmaj[dn][ix][iy] == PSURF800 && (Geo.presurf[i]>800. && Geo.presurf[i]<=900.)) ||
        (psurfmaj[dn][ix][iy] == PSURF900 && Geo.presurf[i]>900.) ){

      //make sure only the dominated surface indicator pixels going into the grid
      if ((Geo.indsurf[i] == Prod.isurf[dn][ix][iy] || Prod.isurf[dn][ix][iy] == 2) && 
	  (Geo.indsurf[i] != MISSING_INT)) {

	//make sure the pixel is not noisy 
	snr5 = 0.0;
	snr6 = 0.0;
	if ( (Dat1.L1rad[i][3][0]!= MISSING_VALUE) && (Dat1.L1rad[i][3][1]!= MISSING_VALUE) ) {
	  snr5 = Dat1.L1rad[i][3][0] / Dat1.L1rad[i][3][1];
	}
	if ( (Dat1.L1rad[i][9][0]!= MISSING_VALUE) && (Dat1.L1rad[i][9][1]!= MISSING_VALUE) ) {
	  snr6 = Dat1.L1rad[i][9][0] / Dat1.L1rad[i][9][1];
	}

	switch (rmPix) {
	case 1: if ( Dat1.swInd[i][0] == 3 || snr5 < 1000 ) // TIR
	    rmflag = 1;	  
	  break;
	case 2:  if ( snr6 < 400 )  // NIR
	    rmflag = 1;
	  break;
	case 3: if (Dat1.swInd[i][0] == 3)    // JNT
	    rmflag = 1;
	  switch (dn) {
	  case 0: if (snr5 < 1000 && snr6 < 400)  // day time
	      rmflag = 1;
	    break;
	  case 1: if (snr5 < 1000 )  // nit time
	      rmflag = 1;
	    break;
	  }	      
	  break;
	}

	if (rmflag == 0) {

	  if ( Geo.solzen[i] != MISSING_VALUE ) {
	    Prod.zensol [dn][ix][iy] += Geo.solzen[i];
	    Num3.nzensol[dn][ix][iy] +=1;
	  }

	  if ( Dat1.satzen[i] != MISSING_VALUE ) {
	    Prod.zensat [dn][ix][iy] += Dat1.satzen[i];
	    Num3.nzensat[dn][ix][iy] +=1;
	  }

	  if ( Geo.presurf[i] != MISSING_VALUE ) {
	    Prod.psurf [dn][ix][iy] += Geo.presurf[i];
	    Num3.npsurf[dn][ix][iy] +=1;
	  }

	  if ( Dat2.demalt[i] != MISSING_VALUE ) {
	    Prod.alt [dn][0][ix][iy] += Dat2.demalt[i];
	    Num3.nalt[dn][ix][iy] +=1;
	  }

	  if ( Dat2.chi2[i] != MISSING_VALUE ) {
	    Prod.chi [dn][0][ix][iy] += Dat2.chi2[i];
	    Num3.nchi[dn][ix][iy] +=1;
	  }

	  // co mixing ratio     
	  for ( k = 0; k < Prs; k++) {
	    if ( Dat2.comix[i][k][0] > COLIMIT  ) {
	      Prod.co_mix  [dn][0][ix][iy][k] += log10f(Dat2.comix[i][k][0]);
	      Prod.co_mix  [dn][1][ix][iy][k] += Dat2.comix[i][k][1] / Dat2.comix[i][k][0];
	      Num3.nco_mix [dn][ix][iy][k] += 1;
	    }
	  }

	  // CO surface mixing ratio
	  if ( Dat2.cosurf [i][0] > COLIMIT ) {
	    Prod.co_surf  [dn][0][ix][iy] += log10f(Dat2.cosurf[i][0]);
	    Prod.co_surf  [dn][1][ix][iy] += Dat2.cosurf[i][1] / Dat2.cosurf[i][0];
	    Num3.nco_surf [dn][ix][iy] += 1;
	  }

	  for ( j = 0; j < Prs1; j++) {
	    if ( Dat1.ak_tot[i][j] != MISSING_VALUE ) {
	      Prod.ak_col[dn][ix][iy][j] += Dat1.ak_tot[i][j];
	      Num3.nakt[dn][ix][iy][j] += 1;
	    }
	    for ( k = 0; k < Prs2; k++) {
	      if ( Dat1.aker[i][j][k] != MISSING_VALUE ) {
		Prod.avgker[dn][ix][iy][j][k] += Dat1.aker[i][j][k];
		Num3.navgker[dn][ix][iy][j][k] += 1;
	      }
	      if ( Dat1.measure_cov[i][j][k] != MISSING_VALUE ) {
		Prod.me_cov[dn][ix][iy][j][k] += Dat1.measure_cov[i][j][k];
		Num3.nmcov[dn][ix][iy][j][k] += 1;
	      }
	      if ( Dat1.smooth_cov[i][j][k] != MISSING_VALUE ) {
		Prod.sm_cov[dn][ix][iy][j][k] += Dat1.smooth_cov[i][j][k];
		Num3.nscov[dn][ix][iy][j][k] += 1;
	      }
	      if ( Dat1.retrival_cov[i][j][k] != MISSING_VALUE ) {
		Prod.re_cov[dn][ix][iy][j][k] += Dat1.retrival_cov[i][j][k];
		Num3.nrcov[dn][ix][iy][j][k] += 1;
	      }
	    }
	  }

	  if ( Dat1.ap_tsurf [i] != MISSING_VALUE ) {
	    Prod.ap_tsurf  [dn][ix][iy] += Dat1.ap_tsurf[i];
	    Num3.nap_tsurf [dn][ix][iy] += 1;
	  } 

	  if ( Dat1.ap_esurf [i] != MISSING_VALUE ) {
	    Prod.ap_esurf  [dn][ix][iy] += Dat1.ap_esurf[i];
	    Num3.nap_esurf [dn][ix][iy] += 1;
	  } 

	  for ( k = 0; k < Prs; k++) {
	    if ( Dat1.ap_comix [i][k] > COLIMIT ) {
	      Prod.ap_co_mix  [dn][ix][iy][k] += log10f(Dat1.ap_comix[i][k]);
	      Num3.nap_co_mix [dn][ix][iy][k] += 1;
	    }
	  }

	  if ( Dat1.ap_cosurf [i] > COLIMIT ) {
	    Prod.ap_co_surf  [dn][ix][iy] += log10f(Dat1.ap_cosurf[i]);
	    Num3.nap_co_surf [dn][ix][iy] += 1;
	  }

	  if ( Dat1.ap_cotot [i] != MISSING_VALUE ) {
	    Prod.ap_co_tot  [dn][ix][iy] += Dat1.ap_cotot[i];
	    Num3.nap_co_tot [dn][ix][iy] += 1;
	  }

	  if ( Dat1.dfs[i] != MISSING_VALUE ) {
	    Prod.DFS [dn][ix][iy] += Dat1.dfs[i];
	    Num3.nDFS[dn][ix][iy] +=1;
	  }

	  if ( Dat1.dryair_col[i] != MISSING_VALUE ) {
	    Prod.da_col [dn][ix][iy] += Dat1.dryair_col[i];
	    Num3.ndry[dn][ix][iy] +=1;
	  }

	  if ( Dat1.watervap_col[i] != MISSING_VALUE ) {
	    Prod.wa_col [dn][ix][iy] += Dat1.watervap_col[i];
	    Num3.nvap[dn][ix][iy] +=1;
	  }

	  for ( t = 0; t < NTWO; t++) {

	    // retrieved surface tempressure
	    if ( Dat2.tsurf [i][t] != MISSING_VALUE ) {
	      Prod.tsurf  [dn][t][ix][iy] += Dat2.tsurf[i][t];
	      Num3.ntsurf [dn][t][ix][iy] += 1;
	  } 

	    // retrieved surface emissivity
	    if ( Dat2.esurf [i][t] != MISSING_VALUE ) {
	      Prod.esurf  [dn][t][ix][iy] += Dat2.esurf[i][t];
	      Num3.nesurf [dn][t][ix][iy] += 1;
	    }  
	    
	    // co total colomn
	    if ( Dat2.cotot[i][t] != MISSING_VALUE ) {
	      Prod.co_colm  [dn][t][ix][iy] += Dat2.cotot[i][t];
	      Num3.nco_totmp [dn][t][ix][iy] += 1;
	    }

	    // co total colomn diags
	    if ( Dat1.co_diag[i][t] != MISSING_VALUE ) {
	      Prod.co_colm_diag [dn][ix][iy][t] += Dat1.co_diag[i][t];
	      Num3.nco_diag [dn][ix][iy][t] += 1;
	    }
	  }
	}
      }  
    } 
  }
  cout << " --- in Pix Grid: " << Prod.co_colm[0][0][30][30] <<"  "<< Prod.co_colm[0][0][40][40] << endl;
}
