/************************ Avg_Grid.C *******************************************************************************\

 PURPOSE
   To average pixel data into 1x1 degree grid

 REVISION HISTORY
   02/09   Debbie Mao

\**********************************************************************************************************************/
#include "Grid.h"
#include "DiagnosticReporter.h"
#include <stdlib.h>

extern diagnostic_reporter diagnosticreporter;


void Avg_Grid ( MOP03_Num Num3, Product &Prod)

{
  int  d, t, j, k, ix, iy;
  bool badAker;

  // Take averages --- Step #1: fields with data only done here -> mean & mean uncertainty ---
  for ( d = 0; d < DAY; d++ )
    for ( ix = 0; ix < XDim; ix++ ) 
      for ( iy = 0; iy < YDim; iy++) {

	badAker = false;

	if ( Num3.nzensol [d][ix][iy] > NLIMIT )   
	  Prod.zensol[d][ix][iy] = Prod.zensol[d][ix][iy] / Num3.nzensol[d][ix][iy];
	else 
	  Prod.zensol[d][ix][iy] = MISSING_VALUE;

	if ( Num3.nzensat [d][ix][iy] > NLIMIT )   
	  Prod.zensat[d][ix][iy] = Prod.zensat[d][ix][iy] / Num3.nzensat[d][ix][iy];
	else 
	  Prod.zensat[d][ix][iy] = MISSING_VALUE;

	if ( Num3.npsurf [d][ix][iy] > NLIMIT )   
	  Prod.psurf[d][ix][iy] = Prod.psurf[d][ix][iy] / Num3.npsurf[d][ix][iy];
	else 
	  Prod.psurf[d][ix][iy] = MISSING_VALUE;

	for ( j = 0; j < Prs1; j++)
	  for ( k = 0; k < Prs2; k++) {	
	    if ( Num3.navgker[d][ix][iy][j][k] > NLIMIT ) 
	      Prod.avgker[d][ix][iy][j][k] = Prod.avgker[d][ix][iy][j][k] / Num3.navgker[d][ix][iy][j][k];
	    else
	      Prod.avgker[d][ix][iy][j][k] = MISSING_VALUE;
	                             
	    if ( (Prod.avgker[d][ix][iy][j][k] < AVGKER_MIN || Prod.avgker[d][ix][iy][j][k] > AVGKER_MAX ) &&
		 (Prod.avgker[d][ix][iy][j][k] != MISSING_VALUE) ) {
	      badAker = true;
	      goto JKOUT;
	    }
	  }
        JKOUT: if ( badAker ) {
	  for ( j = 0; j < Prs1; j++)
	    for ( k = 0; k < Prs2; k++) 
	      Prod.avgker[d][ix][iy][j][k] = MISSING_VALUE;
	}

	if ( Num3.nap_tsurf[d][ix][iy] > NLIMIT )   
	  Prod.ap_tsurf[d][ix][iy] = Prod.ap_tsurf[d][ix][iy] / Num3.nap_tsurf[d][ix][iy];
	else 
	  Prod.ap_tsurf[d][ix][iy] = MISSING_VALUE;

	if ( Num3.nap_esurf[d][ix][iy] > NLIMIT )   
	  Prod.ap_esurf[d][ix][iy] = Prod.ap_esurf[d][ix][iy] / Num3.nap_esurf[d][ix][iy];
	else 
	  Prod.ap_esurf[d][ix][iy] = MISSING_VALUE;

	for ( k = 0; k < Prs; k++) {
	  if ( Num3.nap_co_mix[d][ix][iy][k] > NLIMIT ) {
	    Prod.ap_co_mix[d][ix][iy][k] = Prod.ap_co_mix[d][ix][iy][k] / Num3.nap_co_mix[d][ix][iy][k];
	    Prod.ap_co_mix[d][ix][iy][k] = powf(10, Prod.ap_co_mix[d][ix][iy][k]);
	  }
	  else 
	    Prod.ap_co_mix[d][ix][iy][k] = MISSING_VALUE;
        }

	if ( Num3.nap_co_surf[d][ix][iy] > NLIMIT ) {
	  Prod.ap_co_surf[d][ix][iy] = Prod.ap_co_surf[d][ix][iy] / Num3.nap_co_surf[d][ix][iy];
	  Prod.ap_co_surf[d][ix][iy] = powf(10, Prod.ap_co_surf[d][ix][iy]);
	}
	else 
	  Prod.ap_co_surf[d][ix][iy] = MISSING_VALUE;

	if ( Num3.nap_co_tot [d][ix][iy] > NLIMIT )   
	  Prod.ap_co_tot[d][ix][iy] = Prod.ap_co_tot[d][ix][iy] / Num3.nap_co_tot[d][ix][iy];
	else 
	  Prod.ap_co_tot[d][ix][iy] = MISSING_VALUE;

	if ( Num3.nDFS [d][ix][iy] > NLIMIT )   
	  Prod.DFS[d][ix][iy] = Prod.DFS[d][ix][iy] / Num3.nDFS[d][ix][iy];
	else 
	  Prod.DFS[d][ix][iy] = MISSING_VALUE;

	if ( Num3.nalt [d][ix][iy] > NLIMIT )   
	  Prod.alt[d][0][ix][iy] = Prod.alt[d][0][ix][iy] / Num3.nalt[d][ix][iy];
	else 
	  Prod.alt[d][0][ix][iy] = MISSING_VALUE;

	if ( Num3.nchi [d][ix][iy] > NLIMIT )   
	  Prod.chi[d][0][ix][iy] = Prod.chi[d][0][ix][iy] / Num3.nchi[d][ix][iy];
	else 
	  Prod.chi[d][0][ix][iy] = MISSING_VALUE;

	if ( Num3.ndry [d][ix][iy] > NLIMIT )   
	  Prod.da_col[d][ix][iy] = Prod.da_col[d][ix][iy] / Num3.ndry[d][ix][iy];
	else 
	  Prod.da_col[d][ix][iy] = MISSING_VALUE;

	if ( Num3.nvap [d][ix][iy] > NLIMIT )   
	  Prod.wa_col[d][ix][iy] = Prod.wa_col[d][ix][iy] / Num3.nvap[d][ix][iy];
	else 
	  Prod.wa_col[d][ix][iy] = MISSING_VALUE;

	for ( j = 0; j < Prs1; j++) {
	  if ( Num3.nakt [d][ix][iy][j] > NLIMIT )   
	    Prod.ak_col[d][ix][iy][j] = Prod.ak_col[d][ix][iy][j] / Num3.nakt[d][ix][iy][j];
	  else 
	    Prod.ak_col[d][ix][iy][j] = MISSING_VALUE;

	  for ( k = 0; k < Prs2; k++) {	
	    if ( Num3.nmcov[d][ix][iy][j][k] > NLIMIT ) 
	      Prod.me_cov[d][ix][iy][j][k] = Prod.me_cov[d][ix][iy][j][k] / Num3.nmcov[d][ix][iy][j][k];
	    else
	      Prod.me_cov[d][ix][iy][j][k] = MISSING_VALUE;

	    if ( Num3.nscov[d][ix][iy][j][k] > NLIMIT ) 
	      Prod.sm_cov[d][ix][iy][j][k] = Prod.sm_cov[d][ix][iy][j][k] / Num3.nscov[d][ix][iy][j][k];
	    else
	      Prod.sm_cov[d][ix][iy][j][k] = MISSING_VALUE;

	    if ( Num3.nrcov[d][ix][iy][j][k] > NLIMIT ) 
	      Prod.re_cov[d][ix][iy][j][k] = Prod.re_cov[d][ix][iy][j][k] / Num3.nrcov[d][ix][iy][j][k];
	    else
	      Prod.re_cov[d][ix][iy][j][k] = MISSING_VALUE;
	  }
	}

	// 0 -- data,  1 -- mean uncertainty
	for ( t = 0; t < NTWO; t++) {
	  // surface tempressure
	  if ( Num3.ntsurf[d][t][ix][iy] > NLIMIT )   
	    Prod.tsurf[d][t][ix][iy] = Prod.tsurf[d][t][ix][iy] / Num3.ntsurf[d][t][ix][iy];
	  else 
	    Prod.tsurf[d][t][ix][iy] = MISSING_VALUE;

	  // surface emissivity
	  if ( Num3.nesurf[d][t][ix][iy] > NLIMIT )   
	    Prod.esurf[d][t][ix][iy] = Prod.esurf[d][t][ix][iy] / Num3.nesurf[d][t][ix][iy];
	  else 
	    Prod.esurf[d][t][ix][iy] = MISSING_VALUE;

	  // co mixing ratio
	  for ( k = 0; k < Prs; k++) {
	    if ( Num3.nco_mix[d][ix][iy][k] > NLIMIT )
	      Prod.co_mix[d][t][ix][iy][k] = Prod.co_mix[d][t][ix][iy][k] / Num3.nco_mix[d][ix][iy][k];
	    else
	      Prod.co_mix[d][t][ix][iy][k] = MISSING_VALUE;
	  }

	  // CO surface mixing ratio
	  if ( Num3.nco_surf [d][ix][iy] > NLIMIT )   
	    Prod.co_surf[d][t][ix][iy] = Prod.co_surf[d][t][ix][iy] / Num3.nco_surf[d][ix][iy] ;
	  else 
	    Prod.co_surf[d][t][ix][iy] = MISSING_VALUE;

	  // co total colomn
	  if ( Num3.nco_totmp[d][t][ix][iy] > NLIMIT ) 
	    Prod.co_colm[d][t][ix][iy] = Prod.co_colm[d][t][ix][iy] / Num3.nco_totmp[d][t][ix][iy];
	  else {
	    Prod.co_colm[d][t][ix][iy] = MISSING_VALUE;
	    Prod.isurf[d][ix][iy] = MISSING_INT;
	  }

	  // co total colomn diag: 0-smoothing err, 1-measurement err
	  if ( Num3.nco_diag[d][ix][iy][t] > NLIMIT ) 
	    Prod.co_colm_diag[d][ix][iy][t] = Prod.co_colm_diag[d][ix][iy][t] / Num3.nco_diag[d][ix][iy][t];
	  else 
	    Prod.co_colm_diag[d][ix][iy][t] = MISSING_VALUE;
	}

	if ( Num3.nco_totmp[d][0][ix][iy] > NLIMIT )
	  Prod.nco_colm[d][ix][iy] = Num3.nco_totmp[d][0][ix][iy];
	else
	  Prod.nco_colm[d][ix][iy] = MISSING_INT;
      } 

  diagnosticreporter.Write(DIAGNOSTICS_WARNING, 400, "The pixel data is averaged into the grid." );

}
