/************************ Get_rmPixels.C *************************************************************************\

 PURPOSE
   To get too noisy pixel numbers, will not add ithem in for MOP03

 REVISION HISTORY
   07/13   Debbie Mao

\**********************************************************************************************************************/
#include "Driver.h" 
#include "DiagnosticReporter.h"
#include <string.h>

extern diagnostic_reporter diagnosticreporter;

bool Get_rmPixel (int& rmPix)
{
  bool isread = true;
  char switchchars [PGSd_PC_VALUE_LENGTH_MAX];

  rmPix = 0;

  if (PGS_PC_GetConfigData (RMPIXEL, switchchars) != PGS_S_SUCCESS) {
    diagnosticreporter.Write(DIAGNOSTICS_ERROR, 140, "Could not read rmPix 1");
    isread = false;
  }
  else {
    rmPix = atoi (switchchars);
  }

  return isread;
}
