/********** DiagnosticReporter.C **************************************************************************************\

 PURPOSE
   To report warning or error 

 REVISION HISTORY
   11/02   Debbie Mao

\**********************************************************************************************************************/
#include "Driver.h"
#include "DiagnosticReporter.h"

diagnostic_reporter :: diagnostic_reporter ()
{
  isopen = false;
  handle = NULL;
  Open();
}


diagnostic_reporter :: ~diagnostic_reporter ()
{
  Close();
}


void diagnostic_reporter :: Open ()
{
  if (PGS_IO_Gen_Open (M3QELOGICAL, PGSd_IO_Gen_Write, &handle, 1) == PGS_S_SUCCESS)
    isopen = true;
  else {
    char report [80];
    (void) sprintf (report, "%s %d\n", "ESystem990 Could not open diagnostic file using logical:", M3QELOGICAL);
    (void) PGS_SMF_GenerateStatusReport (report);
    cout << "There is a problem to open diagnostic reporter:" << report << "\n";
    exit (0);
  }
}


void diagnostic_reporter :: Write (enum diagnostics_error_code errorcode, int diagnosticscode, string const& msg)
{
  char charvalue[4];
  (void) sprintf (charvalue, "%d", diagnosticscode);
  
  // make a container for the diagnostic message
  string message;
  message = charvalue;
  if (errorcode == DIAGNOSTICS_ERROR)
    message += "E  ";
  else 
    message += "W  ";
  message += msg;
  
  // write to file
  fputs (message.c_str (), handle);
  fputc ('\n', handle);

  // if errorcode denotes error, shut down the processor
  if (errorcode == DIAGNOSTICS_ERROR) {
    Close ();
    exit (0);
  }
}


void diagnostic_reporter :: Close ()
{
  // make sure the file is open
  if (isopen) {

    // the last entry should be either normal or abnormal termination
    string message = "System000  Normal Termination";

    // close the file
    if (PGS_IO_Gen_Close (handle) == PGS_S_SUCCESS) {
      isopen = false;
      cout << message.c_str () << endl;
    }
    else {
      string report = "ESystem990  Could not close diagnostic file";
      (void) PGS_SMF_GenerateStatusReport ((char*) report.c_str ());
      cout << report.c_str () << endl;
    }
  }
}
