      SUBROUTINE r_ren(nw,wl,wc,nz,tlev,airden,j,sq,jlabel,tpflag)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide product (cross section) x (quantum yield) for                    =*
*=   halocarbons studied by Yangang Ren (CNRS France) in 2017                =*
*-----------------------------------------------------------------------------*
*=  PARAMETERS:                                                              =*
*=  NW     - INTEGER, number of specified intervals + 1 in working        (I)=*
*=           wavelength grid                                                 =*
*=  WL     - REAL, vector of lower limits of wavelength intervals in      (I)=*
*=           working wavelength grid                                         =*
*=  WC     - REAL, vector of center points of wavelength intervals in     (I)=*
*=           working wavelength grid                                         =*
*=  NZ     - INTEGER, number of altitude levels in working altitude grid  (I)=*
*=  TLEV   - REAL, temperature (K) at each specified altitude level       (I)=*
*=  AIRDEN - REAL, air density (molec/cc) at each altitude level          (I)=*
*=  J      - INTEGER, counter for number of weighting functions defined  (IO)=*
*=  SQ     - REAL, cross section x quantum yield (cm^2) for each          (O)=*
*=           photolysis reaction defined, at each defined wavelength and     =*
*=           at each defined altitude level                                  =*
*=  JLABEL - CHARACTER*50, string identifier for each photolysis reaction (O)=*
*=           defined                                                         =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airden(kz)

* weighting functions

      CHARACTER*50 jlabel(kj)
      INTEGER TPFLAG(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=300)

      INTEGER iw
      INTEGER i, n
      REAL x(kdata), y(kdata)
      integer nn
      INTEGER ierr

* local

      REAL yg(kw)
      REAL qy, dum

*********** - 1

      j = j + 1
      jlabel(j) = 'CF3CF2C(O)CF(CF3)2_REN' 
      OPEN(UNIT=kin,
     $     FILE='DATAJ1/REN/CF3CF2C_O_CF_CF3_2_REN.abs'
     $     ,STATUS='OLD')
      DO i = 1, 4
         READ(kin,*)
      ENDDO
      n = 181
      DO i = 1, n
         READ(kin,*) x(i), y(i)
         y(i) = y(i) * 1.e-20
      ENDDO
      CLOSE(kin)
      CALL terint(nw,wl,yg, n,x,y, 1,0)

* quantum yields (only given at 300 nm) from REN
* (D'Anna has 0.043 at 298 nm)

      qy = 0.017

      DO iw = 1, nw-1
        DO i = 1, nz
          sq(j,i,iw) = qy * yg(iw)
        ENDDO
      ENDDO 
      tpflag(j) = 0

************** - 2

      j = j + 1
      jlabel(j) = 'CF3CF2C(O)CF(CF3)2_Taniguchi' 
      write(*,*) jlabel
      OPEN(UNIT=kin,
     $     FILE='DATAJ1/REN/CF3CF2C_O_CF_CF3_2_Taniguchi.abs'
     $     ,STATUS='OLD')
      DO i = 1, 4
         READ(kin,*)
      ENDDO
      n = 27
      DO i = 1, n
         READ(kin,*) x(i), y(i)
         y(i) = y(i) * 1.e-20
      ENDDO
      CLOSE(kin)
      CALL terint(nw,wl,yg, n,x,y, 1,0)

* quantum yield not given.  Use value from REN at 300 nm

      qy = 0.017

      DO iw = 1, nw-1
        DO i = 1, nz
          sq(j,i,iw) = qy * yg(iw)
        ENDDO
      ENDDO 
      tpflag(j) = 0

*********** - 3

      j = j + 1
      jlabel(j) = 'CF3C(O)CF(CF3)2_REN' 
      write(*,*) jlabel
      OPEN(UNIT=kin,
     $     FILE='DATAJ1/REN/CF3C_O_CF_CF3_2_REN.abs'
     $     ,STATUS='OLD')
      DO i = 1, 4
         READ(kin,*)
      ENDDO
      n = 184
      DO i = 1, n
         READ(kin,*) x(i), y(i)
         y(i) = y(i) * 1.e-20
      ENDDO
      CLOSE(kin)
      CALL terint(nw,wl,yg, n,x,y, 1,0)

* quantum yields (only given at 300 nm)

      qy = 0.05

      DO iw = 1, nw-1
        DO i = 1, nz
          sq(j,i,iw) = qy * yg(iw)
        ENDDO
      ENDDO 
      tpflag(j) = 0

*********** - 4

      j = j + 1
      jlabel(j) = 'CH3CH2C(O)CH(CH3)2_Diaz_de_Mera'
      write(*,*) jlabel

      OPEN(UNIT=kin,
     $     FILE='DATAJ1/REN/CH3CH2C_O_CH_CH3_2_Diaz_de_Mera.abs'
     $     ,STATUS='OLD')
      DO i = 1, 4
         READ(kin,*)
      ENDDO
      n = 27
      DO i = 1, n
         READ(kin,*) x(i), y(i)
         y(i) = y(i) * 1.e-20
      ENDDO
      CLOSE(kin)
      CALL terint(nw,wl,yg, n,x,y, 1,0)

* quantum yields (only given at 300 nm) from REN

      qy = 0.179

      DO iw = 1, nw-1
        DO i = 1, nz
          sq(j,i,iw) = qy * yg(iw)
        ENDDO
      ENDDO 
      tpflag(j) = 0

*********** - 5

      j = j + 1
      jlabel(j) = 'CH3CH2C(O)CH(CH3)2_REN'
      write(*,*) jlabel

      OPEN(UNIT=kin,
     $     FILE='DATAJ1/REN/CH3CH2C_O_CH_CH3_2_REN.abs'
     $     ,STATUS='OLD')
      DO i = 1, 4
         READ(kin,*)
      ENDDO
      n = 181
      DO i = 1, n
         READ(kin,*) x(i), y(i)
         y(i) = y(i) * 1.e-20
      ENDDO
      CLOSE(kin)
      CALL terint(nw,wl,yg, n,x,y, 1,0)

* quantum yields (only given at 300 nm)

      qy = 0.179

      DO iw = 1, nw-1
        DO i = 1, nz
          sq(j,i,iw) = qy * yg(iw)
        ENDDO
      ENDDO 
      tpflag(j) = 0

      RETURN
      END

