   pro rdnorman_hno3,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='norman_hno3_h2o.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnlines=ncdf_varid(nc_id,'nlines')
  idnweights=ncdf_varid(nc_id,'nweights')
  idwhno3=ncdf_varid(nc_id,'whno3')
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnlines,nlines
  ncdf_varget,nc_id,idnweights,nweights
  ncdf_varget,nc_id,idwhno3,whno3
  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  print,'  '
  print,'  norman_hno3 '
  print,'  specify hno3 (35.0 45.0 54.0 63.0 70.0)'
  read,hno3

   diffmin=1.0e6
   j=-99
  for i=0,nweights-1 do begin
    diff=abs(hno3-whno3(i))
   if (diff lt diffmin) then begin
    j=i
    diffmin=diff
   endif
  endfor

; ***
   text2=string(hno3)
   lset=strcompress(lstrn+text2)

; *****
; Specify the indices
    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
   for i=0,nlines-1 do begin
    rndat(i)=rn(i,j)
    ridat(i)=ri(i,j)
   endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdnorman_hno3: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdnorman_hno3: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


