   pro rdniedziela_h2so4,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='niedziela_h2so4.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnlines=ncdf_varid(nc_id,'nlines')
  idnumlines=ncdf_varid(nc_id,'numlines')
  idnwh2so4=ncdf_varid(nc_id,'nwh2so4')
  idwh2so4=ncdf_varid(nc_id,'wh2so4')
  idntemps=ncdf_varid(nc_id,'ntemps')
  idtemps=ncdf_varid(nc_id,'temps')
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnlines,nlines2
  ncdf_varget,nc_id,idnumlines,numlines
  ncdf_varget,nc_id,idnwh2so4,nwh2so4
  ncdf_varget,nc_id,idwh2so4,wh2so4
  ncdf_varget,nc_id,idntemps,ntemps
  ncdf_varget,nc_id,idtemps,temps
  ncdf_varget,nc_id,idwcm,wcm2
  ncdf_varget,nc_id,idwavelength,wavelength2
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  print,'  '
  print,'  niedziela h2so4'
  print,'  nwh2so4 ',nwh2so4
  print,'  ntemps ',ntemps
  print,'  The table to choose from'
  for i=0,ntemps-1 do begin
   vec=fltarr(nwh2so4)
   for j=0,nwh2so4-1 do begin
    vec(j)=wh2so4(i,j)
   endfor
   print,'  ',i,temps(i),vec
  endfor

   print,'  '
   print,'  niedziela h2so4: specify temp value (e.g. 220.0)' 
   read,temp

   print,'  '
   print,'  niedziela h2so4: specify h2so4 value (e.g. 72.0)' 
   read,h2so4

    jtemp=-99
   for j=0,ntemps-1 do begin
    if (temp le temps(j)) then begin
     jtemp=j
     goto,jump1
    endif
   endfor
   jump1:mn=0

    kh2so4=-99
   if (jtemp ge 0) then begin
    for k=0,nwh2so4-1 do begin
     if (h2so4 le wh2so4(jtemp,k)) then begin
      kh2so4=k
      goto,jump2
     endif
    endfor
    jump2:mn=0
   endif

   if ((jtemp lt 0) or (kh2so4 lt 0)) then begin
    print,'  '
    print,'  jtemp,kh2so4 ',jtemp,kh2so4
    print,'  jtemp or kh2so4 lt 0, will stop'
    stop
   endif

; **
   tempstr=strarr(1)
   tempstr=string(fix(temps(jtemp)))
   h2so4str=strarr(1)
   h2so4str=string(fix(wh2so4(jtemp,kh2so4)))

; **
     nlines=fix(numlines(jtemp))
    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
    wcm=fltarr(nlines)
    wavelength=fltarr(nlines)

    print,'  '
    print,'  rdniedziela_h2so4: nlines,temp,jtemp,temps(jtemp) '
    print,'  ',nlines,temp,jtemp,temps(jtemp)
    print,'  rdniedziela_h2so4: nlines,h2so4,kh2so4,wh2so4(jtemp,kh2so4) '
    print,'  ',nlines,h2so4,kh2so4,wh2so4(jtemp,kh2so4)

    printf,iout,'  '
    printf,iout,'  rdniedziela_h2so4: nlines,temp,jtemp,temps(jtemp) '
    printf,iout,'  ',nlines,temp,jtemp,temps(jtemp)
    printf,iout,'  rdniedziela_h2so4: nlines,h2so4,kh2so4,wh2so4(jtemp,kh2so4) '
    printf,iout,'  ',nlines,h2so4,kh2so4,wh2so4(jtemp,kh2so4)

; ****
; From the ncdump
;       float temps(ntemps) ;
;       float numlines(ntemps) ;
;       float wh2so4(nwh2so4, ntemps) ;
;       float ncomps(ntemps) ;
;       float wcm(ntemps, nlines) ;
;       float wavelength(ntemps, nlines) ;
;       float rn(nwh2so4, ntemps, nlines) ;
;       float ri(nwh2so4, ntemps, nlines) 

; ****
; Specify the output values
   for i=0,nlines-1 do begin
    rndat(i)=rn(i,jtemp,kh2so4)
    ridat(i)=ri(i,jtemp,kh2so4)
    wcm(i)=wcm2(i,jtemp)
    wavelength(i)=wavelength2(i,jtemp)
   endfor

; Graphs label
   lset=strcompress(lstrn+' '+tempstr+' K '+h2so4str+' %')

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdniedziela_h2so4: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdniedziela_h2so4: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


