   pro rddibiagio,nopr,iout,filnm,$
   ntext,text,$
   nlines,wcm,wavelength,rn,ri,rnerr,rierr

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
; print,filnm
; stop

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnfiles=ncdf_varid(nc_id,'nfiles')
  idnwave=ncdf_varid(nc_id,'nwave')

  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')

  idtext=ncdf_varid(nc_id,'text')
  iddesert10=ncdf_varid(nc_id,'desert10')
  iddesert9=ncdf_varid(nc_id,'desert9')

  idn70=ncdf_varid(nc_id,'n70')
  idn19=ncdf_varid(nc_id,'n19')
  idn10=ncdf_varid(nc_id,'n10')
  idn9=ncdf_varid(nc_id,'n9')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idn19,n19
  ncdf_varget,nc_id,idn10,n10
  ncdf_varget,nc_id,idn9,n9
  ncdf_varget,nc_id,idnfiles,nfiles
  ncdf_varget,nc_id,idnwave,nwave

; ncdf_varget,nc_id,idnweights,nweights
; ncdf_varget,nc_id,idwhno3,whno3

  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rndat
  ncdf_varget,nc_id,idri,ridat


  text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

  desert10=strarr(n10,n10)
  desert9=strarr(n10,n9)

  ncdf_varget,nc_id,iddesert10,desert10
  desert10=string(desert10)

  ncdf_varget,nc_id,iddesert9,desert9
  desert9=string(desert9)

; ****
; Phooey
   desert10=['Algeria  0','Arizona  1','Atacama  2','Austral  3','Bodele   4','Ethiopia 5','Gobi     6','Kuwait    7','Libya    8','Mali     9']
    desert9=['Maurit  10','Morocco 11','Namib-1 12','Namib-2 13','Niger   14','Patagon 15','Saud    16','Taklim   17','Tunisia 18']

; ****
; Close the data set
  ncdf_close,nc_id

; ****
   ihelp=0
  if (ihelp eq 1) then begin
   help,rndat
   help,ridat
   help,wcm
   help,wavelength
   help,nwave
   help,ntext
   help,text
   help,desert10
   help,desert9
   stop
; RNDAT           FLOAT     = Array[601, 19]
; RIDAT           FLOAT     = Array[601, 19]
; WCM             FLOAT     = Array[601]
; WAVELENGTH      FLOAT     = Array[601]
; NWAVE           INT       =      601
; NTEXT           INT       =       39
; TEXT            STRING    = Array[39]
; DESERT10        STRING    = Array[10]
; DESERT9         STRING    = Array[9]
  endif

; *****
  print,'  '
  print,'  Di Bagio desert '
  print,'  desert10 ',desert10
  print,'  desert9 ',desert9
  print,'  specify j (from 0 to 18)'
  read,j

  jval=j

; ***
  if (j le 9) then begin
   text2=string(desert10(j))
  endif
  if (j ge 10) then begin
   text2=string(desert9(j-10))
  endif
;  lset=strcompress(lstrn+text2)

; *****
; Output 

; Specify the indices
    rn=fltarr(nwave)
    ri=fltarr(nwave)
; have error values as 0.0
    rnerr=fltarr(nwave)
    rierr=fltarr(nwave)
   for i=0,nwave-1 do begin
    rn(i)=rndat(i,j)
    ri(i)=ridat(i,j)
   endfor

   nlines=nwave

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rddibiagio: filnm ',filnm
    printf,iout,'  '
    printf,iout,'  rddibiagio: next ',ntext
    printf,iout,'  rddibiagio: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rddibiagio: nlines ',nlines
   printf,iout,'  rddibiagio: text2 ',text2
   printf,iout,'  rddibiagio: i,wcm,wavelength,rn and ri'
   for i=0,nwave-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rn(i),ri(i)
   endfor

  endif

; ******
  return
  end
