   pro rddeguine_ash,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; One file
   fil=strarr(1)
   fil='deguine_ash.nc'

; ***
; Read in the data from the netCDF file

; For graphs
   lset=lstrn

; ***
; The input netCDF file
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
  idnlines=ncdf_varid(nc_id,'nlines')
  ncdf_varget,nc_id,idnlines,nlines

  idnsets=ncdf_varid(nc_id,'nsets')
  ncdf_varget,nc_id,idnsets,nsets

  idntext=ncdf_varid(nc_id,'ntext')
  ncdf_varget,nc_id,idntext,ntext

  idn70=ncdf_varid(nc_id,'n70')
  ncdf_varget,nc_id,idn70,n70

  idn60=ncdf_varid(nc_id,'n60')
  ncdf_varget,nc_id,idn60,n60

  idn6=ncdf_varid(nc_id,'n6')
  ncdf_varget,nc_id,idn6,n6

; ****
   text=strarr(ntext)
  idtext=ncdf_varid(nc_id,'text')
  ncdf_varget,nc_id,idtext,text
  text=string(text)

   setsstr=strarr(nsets)
  idsetsstr=ncdf_varid(nc_id,'setsstr')
  ncdf_varget,nc_id,idsetsstr,setsstr
  setsstr=string(setsstr)

; *****
; Read in the data
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')

; ***
; Get data
  ncdf_varget,nc_id,idwcm,wcm3
  ncdf_varget,nc_id,idwavelength,wavelength3
  ncdf_varget,nc_id,idrn,rndat3
  ncdf_varget,nc_id,idri,ridat3

; ****
; Close the data set
  ncdf_close,nc_id

; *****
; Select the laboratory condition to work with
   print,'  '
   print,'  rddeguine: nsets ',nsets
   print,'  rddeguine: i,setsstr(i)'
  for i=0,nsets-1 do begin
   i2=i+1
   print,'  ',i2,'  ',setsstr(i)
  endfor

  print,'  specify the iset sample to work with, iset=1,2,3,4,5,6'
  read,iset
  iset=fix(iset)

  printf,iout,'  rddeguine: iset ',iset
  printf,iout,'  rddeguine: setsstr ',setsstr(iset-1)

; *****
; Output
  wcm=fltarr(nlines)
  wavelength=fltarr(nlines)
  rndat=fltarr(nlines)
  ridat=fltarr(nlines)

; ****
   j=iset-1
  for i=0,nlines-1 do begin
   wavelength(i)=wavelength3(i)
   wcm(i)=wcm3(i)
   rndat(i)=rndat3(i,j)
   ridat(i)=ridat3(i,j)
  endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rddeguine_ash: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,'  ',text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rddeguine_ash: filnm ',filnm
   printf,iout,'  rddeguine_ash: fil ',fil
   printf,iout,'  rddeguine: iset ',iset
   printf,iout,'  rddeguine: setsstr ',setsstr(iset-1)
   printf,iout,'  rddeguine_ash: nlines ',nlines
   printf,iout,'  rddeguine_ash: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
