   pro rdclapp_ice,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='clapp_ice.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnlines=ncdf_varid(nc_id,'nlines')
  idnumlines=ncdf_varid(nc_id,'numlines')
  idntemps=ncdf_varid(nc_id,'ntemps')
  idtemps=ncdf_varid(nc_id,'temps')
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnlines,nlines
  ncdf_varget,nc_id,idnumlines,numlines
  ncdf_varget,nc_id,idntemps,ntemps
  ncdf_varget,nc_id,idtemps,temps
  ncdf_varget,nc_id,idwcm,wcm2
  ncdf_varget,nc_id,idwavelength,wavelength2
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
   print,'  '
   print,'  clapp ice: specify temp ( 130, 140, 150, 160, 170, 180, 190, 200, 210 ) '
   read,temp

    a1=(temp-temps(0))/10
    j=fix(a1)
    tempstr=strarr(1)
    tempstr=string(fix(temps(j)))

     nlines=numlines(j)
    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
    wcm=fltarr(nlines)
    wavelength=fltarr(nlines)

    print,'  '
    print,'  rdclapp_ice: nlines,temp,j,temps(j) ',nlines,temp,j,temps(j)

    printf,iout,'  '
    printf,iout,'  rdclapp_ice: nlines,temp,j,temps(j) ',nlines,temp,j,temps(j)

   for i=0,nlines-1 do begin
    rndat(i)=rn(i,j)
    ridat(i)=ri(i,j)
    wcm(i)=wcm2(i,j)
    wavelength(i)=wavelength2(i,j)
   endfor

; Graphs label
   lset=strcompress(lstrn+' '+tempstr)

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdclapp_ice: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdclapp_ice: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


