   pro rdwork,noprwork,$
   noprtest,noprlist,noprind,$
   noprwave,noprsize,noprext,$
   iout,indir,outdir,fout,$
   itest,iset,igraphi,igraphd,igraphe,$
   iwrind,iwrsize,iwrext,$
   iuser_sizedist,$
   iuser_indices,$
   iuser_calc,$
   iwave,w1,w2,dw,r1,r2,$
   den1,rad1,sig1,$
   den2,rad2,sig2,$
   icompare,iset1,iset2,$
   icompare_spectra,$
   imultisetsgraph,$
   imix,imix1,imix2

; ************************
; Output 

; Test the routine with itest=1
   itest=intarr(1)
; iset specifies the index of reafraction set to work with
   iset=intarr(1)
; iwave=1 for wavenumber scale, iwave=2 for wavelength scale
   iwave=intarr(1)

; To compare two sets of indices, icompare=1
   icompare=intarr(1)
   iset1=intarr(1)
   iset2=intarr(1)

; To graph multiple sets of indices, imultisetsgraph=1
   imultisetsgraph=intarr(1)

; To compare two spectra with icompare_spectra=1
   icompare_spectra=intarr(1)

; User specified size distribution
   iuser_sizedist=intarr(1)

; User specified indices
   iuser_indices=intarr(1)

; User specified user.pro (e.g. calculation over a user specified profile)
   iuser_calc=intarr(1)

; To compare mixing rules for multi-component species, imix=1
   imix=intarr(1)
   imix1=intarr(1)
   imix2=intarr(1)

; Will graph the indices, size distribution, and spectra when
; these flags are set to 1
   igraphi=intarr(1)
   igraphd=intarr(1)
   igraphe=intarr(1)

; Will write out to ascii and netCDF files, the indices, size distribution
; and the spectra with these flags set to 1
   iwrind=intarr(1)
   iwrsize=intarr(1)
   iwrext=intarr(1)

; Print flags for the various routines (1 to print, 0 not to print)
   noprwork=intarr(1)
   noprtest=intarr(1)
   noprlist=intarr(1)
   noprind=intarr(1)
   noprwave=intarr(1)
   noprsize=intarr(1)
   noprext=intarr(1)

; *************************
; The   work.dat  ascii file has specifications for the work to be done
   file=strarr(1)
   file='work.dat'

; *************************
    idat=30
   header=strarr(1)
   blankline=strarr(1)

; Open the ascii file
   openr,idat,file

   readf,idat,header
   readf,idat,header
   readf,idat,header
   readf,idat,header
   readf,idat,header

   readf,idat,itest
   readf,idat,blankline

   readf,idat,header
   readf,idat,icompare
   readf,idat,header
   readf,idat,header
   readf,idat,iset1,iset2
   readf,idat,blankline

   readf,idat,header
   readf,idat,header
   readf,idat,imultisetsgraph
   readf,idat,blankline

   readf,idat,header
   readf,idat,header
   readf,idat,icompare_spectra
   readf,idat,blankline

   readf,idat,header
   readf,idat,imix
   readf,idat,header
   readf,idat,header
   readf,idat,header
   readf,idat,imix1,imix2
   readf,idat,blankline

   readf,idat,header
   readf,idat,header
   readf,idat,iset
   readf,idat,blankline
   readf,idat,igraphi
   readf,idat,blankline

   readf,idat,header
   readf,idat,iwave
   readf,idat,header
   readf,idat,header
   readf,idat,w1,w2,dw
   readf,idat,blankline

   readf,idat,header
   readf,idat,iuser_sizedist
   readf,idat,blankline

   readf,idat,header
   readf,idat,iuser_indices
   readf,idat,blankline

   readf,idat,header
   readf,idat,iuser_calc
   readf,idat,blankline

   readf,idat,header
   readf,idat,header
   readf,idat,den1,rad1,sig1
   readf,idat,header
   readf,idat,den2,rad2,sig2
   readf,idat,header
   readf,idat,r1,r2
   readf,idat,header
   readf,idat,igraphd
   readf,idat,blankline

   readf,idat,header
   readf,idat,header
   readf,idat,igraphe
   readf,idat,blankline

   readf,idat,header
   readf,idat,iwrind
   readf,idat,header
   readf,idat,iwrsize
   readf,idat,header
   readf,idat,iwrext

   readf,idat,header
   readf,idat,header
   readf,idat,noprwork
   readf,idat,header
   readf,idat,noprtest
   readf,idat,header
   readf,idat,noprlist
   readf,idat,header
   readf,idat,noprind
   readf,idat,header
   readf,idat,noprwave
   readf,idat,header
   readf,idat,noprsize
   readf,idat,header
   readf,idat,noprext

; Close the directory.dat file
   close,idat

; *************************
; Write out to the output ascii file
   if (noprwork eq 1) then begin

; ***
    printf,iout,'  '
    printf,iout,'  rdwork: will do a test of the routines when itest is nonzero
    printf,iout,'  rdwork: itest ',itest

; ***
    printf,iout,'  '
    printf,iout,'  rdwork: will compare 2 sets of indices if icompare=1'
    printf,iout,'  rdwork: icompare,iset1,iset2'
    printf,iout,'  ',icompare(0),iset1(0),iset2(0)

    printf,iout,'  '
    printf,iout,'  rdwork: will multiple sets of indices if imultisetsgraph=1'
    printf,iout,'  rdwork: imultisetsgraph,'
    printf,iout,'  ',imultisetsgraph(0)

    printf,iout,'  '
    printf,iout,'  rdwork: will compare spectra if icompare_spectra=1'
    printf,iout,'  rdwork: icompare_spectra'
    printf,iout,'  ',icompare_spectra(0)

    printf,iout,'  '
    printf,iout,'  rdwork: will compare mixing rules if imix=1'
    printf,iout,'  rdwork: imix,imix1,imix2
    printf,iout,'  ',imix(0),imix1(0),imix2(0)

; ***
; Standard specificiation of indices
    if (iuser_indices ne 1) then begin

     printf,iout,'  '
     printf,iout,'  rdwork: index set ',iset
     printf,iout,'  rdwork: graph indices with igraphi=1'
     printf,iout,'  rdwork: igraphi ',igraphi

     printf,iout,'  '
     printf,iout,'  rdwork: iwave=1,2 for wavenumber or wavelength specification'
     printf,iout,'  rdwork: iwave ',iwave
     if (iwave eq 1) then begin
      printf,iout,'  rdwork: w1,w2,dw are in wavenumbers'
     endif
     if (iwave eq 2) then begin
      printf,iout,'  rdwork: w1,w2,dw are in microns'
     endif
     printf,iout,'  rdwork: w1,w2,dw ',w1,w2,dw

   endif


; User specified indices
    if (iuser_indices eq 1) then begin
     printf,iout,'  '
     printf,iout,'  rdwork: will use user specified indices '
    endif

; *****
; Standard specification of size distribution
    if (iuser_sizedist ne 1) then begin

     printf,iout,'  '
     printf,iout,'  rdwork: will use stardard size distbirution input '
     printf,iout,'  rdwork: by specification of log-normal size distribution'
     printf,iout,'  rdwork: size distribution radii range in microns'
     printf,iout,'  rdwork: r1,r2 ',r1,r2
     printf,iout,'  rdwork: den,rad,sig are number density, mean radii, width'
     printf,iout,'  rdwork: 1st log-normal size distribution parameters'
     printf,iout,'  rdwork: den1,rad1,sig1'
     printf,iout,'  ',den1,rad1,sig1
     printf,iout,'  rdwork: den2,rad2,sig2'
     printf,iout,'  ',den2,rad2,sig2
     printf,iout,'  rdwork: graph size distribution with igraphd=1'
     printf,iout,'  rdwork: igraphd ',igraphd

    endif

; User specified size distribution
    if (iuser_sizedist eq 1) then begin
     printf,iout,'  '
     printf,iout,'  rdwork: will use user specified size distribution'
     printf,iout,'  rdwork: graph size distribution with igraphd=1'
     printf,iout,'  rdwork: igraphd ',igraphd
    endif

; User will write user.pro (e.g. calculation over user specified profile)
    if (iuser_calc eq 1) then begin
     printf,iout,'  '
     printf,iout,'  rdwork: user will write  user.pro  and do calculation'
    endif

; *****
; Print flags
    printf,iout,'  '
    printf,iout,'  rdwork: write out indices to ascii and netCDF output files'
    printf,iout,'  rdwork: iwrind ',iwrind(0)
    printf,iout,'  rdwork: write size distribution to ascii and netCDF files'
    printf,iout,'  rdwork: iwrsize ',iwrsize(0)
    printf,iout,'  rdwork: write out spectra to ascii and netCDF output files'
    printf,iout,'  rdwork: iwrext ',iwrext(0)

    printf,iout,'  '
    printf,iout,'  rdwork: will write out to the f.out ascii file when'
    printf,iout,'  rdwork: the print flags are set to 1'
    printf,iout,'  rdwork: noprwork, noprtest, noprlist, noprind'
    printf,iout,'  ',noprwork(0),noprtest(0),noprlist(0),noprind(0)
    printf,iout,'  rdwork: noprwave, noprsize, noprext'
    printf,iout,'  ',noprwave(0),noprsize(0),noprext(0)

   endif

; *************************
  return
  end
