   pro rdpalmer,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='palmer_williams_h2so4.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnlines=ncdf_varid(nc_id,'nlines')
  idnwh2so4=ncdf_varid(nc_id,'nwh2so4')
  idwh2so4=ncdf_varid(nc_id,'wh2so4')
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnlines,nlines
  ncdf_varget,nc_id,idnwh2so4,nwh2so4
  ncdf_varget,nc_id,idwh2so4,wh2so4
  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  print,'  '
  print,'  palmer and williams h2so4'
  print,'  specify h2so4 (25, 38, 50, 75, 84.5, 95.6)'
  read,h2so4

; **
  n6=6
  h2so4v=fltarr(n6)
  h2so4v=[25.0,38.0,50.0,75.0,84.5,95.6]
   diffmin=1.0e6
   j=-99
  for i=0,n6-1 do begin
    diff=abs(h2so4-wh2so4(i))
   if (diff lt diffmin) then begin
    j=i
    diffmin=diff
   endif
  endfor

; **
   text2=string(h2so4)
   lset=strcompress(lstrn+text2)

; *****
    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
   for i=0,nlines-1 do begin
    rndat(i)=rn(i,j)
    ridat(i)=ri(i,j)
   endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdpalmer: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdpalmer: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


