   pro rdliu_soa_est,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; One file
   fil=strarr(1)
   fil='liu_soa_est.nc'

; ***
; Read in the data from the netCDF file

; For graphs
   lset=lstrn

; ***
; The input netCDF file
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
  idnlines=ncdf_varid(nc_id,'nlines')
  ncdf_varget,nc_id,idnlines,nlines

  idnlab=ncdf_varid(nc_id,'nlab')
  ncdf_varget,nc_id,idnlab,nlab

  idntext=ncdf_varid(nc_id,'ntext')
  ncdf_varget,nc_id,idntext,ntext

  idn70=ncdf_varid(nc_id,'n70')
  ncdf_varget,nc_id,idn70,n70

  idn60=ncdf_varid(nc_id,'n60')
  ncdf_varget,nc_id,idn60,n60

  idn3=ncdf_varid(nc_id,'n3')
  ncdf_varget,nc_id,idn3,n3

; ****
   text=strarr(ntext)
  idtext=ncdf_varid(nc_id,'text')
  ncdf_varget,nc_id,idtext,text
  text=string(text)

   labstr=strarr(nlab)
  idlabstr=ncdf_varid(nc_id,'labstr')
  ncdf_varget,nc_id,idlabstr,labstr
  labstr=string(labstr)

; *****
; Read in the data
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')

; ***
; Get data
  ncdf_varget,nc_id,idwcm,wcm3
  ncdf_varget,nc_id,idwavelength,wavelength3
  ncdf_varget,nc_id,idrn,rndat3
  ncdf_varget,nc_id,idri,ridat3

; ****
; Close the data set
  ncdf_close,nc_id

; *****
; Select the laboratory condition to work with
   print,'  '
   print,'  rdliu_soa_est: nlab ',nlab
   print,'  rdliu_soa_est: i,labstr(i)'
  for i=0,nlab-1 do begin
   print,'  ',labstr(i)
  endfor

  print,'  specify the ilab condition to work with, ilab=1,2,3'
  read,ilab
  ilab=fix(ilab)

  printf,iout,'  rdliu_soa_est: ilab ',ilab
  printf,iout,'  rdliu_soa_est: labstr ',labstr(ilab-1)

; *****
   nlines3=intarr(3)
   nlines3=[155,195,195]

; Output
   nlines=nlines3(ilab-1)
  wcm=fltarr(nlines)
  wavelength=fltarr(nlines)
  rndat=fltarr(nlines)
  ridat=fltarr(nlines)

; ****
   j=ilab-1
  for i=0,nlines-1 do begin
   wavelength(i)=wavelength3(i)
   wcm(i)=wcm3(i)
   rndat(i)=rndat3(i,j)
   ridat(i)=ridat3(i,j)
  endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdliu_soa_est: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,'  ',text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdliu_soa_est: filnm ',filnm
   printf,iout,'  rdliu_soa_est: nlines ',nlines
   printf,iout,'  rdliu_soa_est: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
