   pro compareindx,nopr,iout,$
   icompare,iset1,iset2,$
   nsets,listrn,lstrn,$
   indir,outdir,iwave,w1,w2

; ************************
   jset=intarr(2)
   jset(0)=iset1
   jset(1)=iset2

; *************************
; iwave=1 for wavenumber scales and iwave=2 for wavelength scales

; *************************
; Loop over the two sets
    mset=-1
   for ncalc=0,1 do begin
    iset=jset(ncalc)
    mset=mset+1

; *************************
; The set to work with
   lstrn=strarr(1)
   lstrn=strcompress(listrn(iset))

; *************************
    noprc=1
  if (noprc eq 1) then begin
   printf,iout,'  '
   printf,iout,'  compareindx: iset '
   printf,iout,'  ',iset
   printf,iout,'  compareindx: lstrn
   printf,iout,'  ',lstrn
   nopr=0
  endif

; *************************
; The iset and numbers here must be corrdinated with the   indices.dat   files
    igraphic=0
    iwrind=0
    noprr=1
   rdindices,noprr,iout,$
   indir,$
   iset,igraphic,$
   nsets,listrn,lstrn,$
   nlines,wcm,wavelength,rndat,ridat,$
   outdir,iwave,iwrind,lset,ibothpos

; **
; Store for output

; First set
    if (mset eq 0) then begin
       nwave1=nlines
      wave1=fltarr(nwave1)
      rn1=fltarr(nwave1)
      ri1=fltarr(nwave1)
     for i=0,nlines-1 do begin
      if (iwave eq 1) then begin
       wave1(i)=wcm(i)
      endif
      if (iwave eq 2) then begin
       wave1(i)=wavelength(i)
      endif
      rn1(i)=rndat(i)
      ri1(i)=ridat(i)
     endfor
     lset1=lset
    endif

; 2nd set
    if (mset eq 1) then begin
       nwave2=nlines
      wave2=fltarr(nwave2)
      rn2=fltarr(nwave2)
      ri2=fltarr(nwave2)
     for i=0,nlines-1 do begin
      if (iwave eq 1) then begin
       wave2(i)=wcm(i)
      endif
      if (iwave eq 2) then begin
       wave2(i)=wavelength(i)
      endif
      rn2(i)=rndat(i)
      ri2(i)=ridat(i)
     endfor
     lset2=lset
    endif

  endfor

; *************************
; Determine how many points to work with

       nuse1=0
      for i=0,nwave1-1 do begin
       if ((wave1(i) ge w1) and (wave1(i) le w2)) then begin
        nuse1=nuse1+1
       endif
      endfor

       nuse2=0
      for i=0,nwave2-1 do begin
       if ((wave2(i) ge w1) and (wave2(i) le w2)) then begin
        nuse2=nuse2+1
       endif
      endfor

; *************************
; Special write of input data when nwave1=nwave2
   iwrsp=0
  if (iwrsp eq 1) then begin
   if (nwave1 eq nwave2) then begin
    printf,iout,'  '
    printf,iout,'  compareindex: special write '
    printf,iout,'  compareindex: nwave1,nwave2 ',nwave1,nwave2
    printf,iout,'  compareindex: i,wave1(i),wave2(i),rn1(i),rn2(i),ri1(i),ri2(i)'
    for i=0,nwave1-1 do begin
     printf,iout,'  ',i,wave1(i),wave2(i),rn1(i),rn2(i),ri1(i),ri2(i)
    endfor
   endif
  endif

; *************************
; Graph the results

; The output ps graphics file
    fileps=strcompress(outdir+'gcompare.ps')

; Open the output ps file
    set_plot, 'ps'
    device, /color, bits_per_pixel=8, file=fileps,$
     /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

; *****
; have graphs plus the color bar
; [ignore,horizontal,vertical]
   !P.MULTI=[0,1,2]

; Load the color table
   loadct,26

; Bold fonts
   !P.font=0

; ****
      ngraphs=2
     titles=strarr(ngraphs)
     titles=['Real Index ','Imaginary Index']

; Specify the points
        ntot=nuse1+nuse2
       xvec=fltarr(ntot)
       yvec=fltarr(ntot)
       isym=intarr(ntot)
       clri=fltarr(ntot)

       xvec1=fltarr(nuse1)
       yvec1=fltarr(nuse1)
       xvec2=fltarr(nuse2)
       yvec2=fltarr(nuse2)

       printf,iout,'  '
       printf,iout,'  compareindx: nwave1,nwave2'
       printf,iout,'  compareindx: ntot,nuse1,nuse2'
       printf,iout,'  ',ntot,nuse1,nuse2

; Loop over the graphs
    for ii=0,ngraphs-1 do begin

; first set
       j=-1
       j1=-1
      for i=0,nwave1-1 do begin
      if ((wave1(i) ge w1) and (wave1(i) le w2)) then begin
        j=j+1
        j1=j1+1
        xvec(j)=wave1(i)
        xvec1(j1)=wave1(i)
       if (ii eq 0) then begin
        yvec(j)=rn1(i)
        yvec1(j1)=rn1(i)
       endif
       if (ii eq 1) then begin
        yvec(j)=ri1(i)
        yvec1(j1)=ri1(i)
       endif
       isym(j)=4
       clri(j)=30.0
       clr1=30.0
      endif
      endfor

       j2=-1
      for i=0,nwave2-1 do begin
      if ((wave2(i) ge w1) and (wave2(i) le w2)) then begin
       j=j+1
       j2=j2+1
       xvec(j)=wave2(i)
       xvec2(j2)=wave2(i)
       if (ii eq 0) then begin
        yvec(j)=rn2(i)
        yvec2(j2)=rn2(i)
       endif
       if (ii eq 1) then begin
        yvec(j)=ri2(i)
        yvec2(j2)=ri2(i)
       endif
       isym(j)=6
       clri(j)=220.0
       clr2=220.0
      endif
      endfor

     iwr=1
    if (iwr eq 1) then begin
      printf,iout,'  '
      printf,iout,'  compareindx: i,xvec(i),yvec(i),isym(i),clri(i)'
     for i=0,ntot-1 do begin
      printf,iout,'  ',i,xvec(i),yvec(i),isym(i),clri(i)
     endfor
    endif

    if (iwave eq 1) then begin
     labelx='Wavenumber (cm-1)'
    endif
    if (iwave eq 2) then begin
     labelx='Wavelength (microns)'
    endif

    labely=titles(ii)
    title=strcompress(lset1+' '+lset2)
    title=' '

    xmin=min(xvec)
    xmax=max(xvec)
    ymin=min(yvec)
    ymax=max(yvec)

    graphxyc2,iout,xvec,yvec,isym,ntot,labelx,labely,title,clri,$
    lset1,lset2,ii,xvec1,yvec1,xvec2,yvec2,clr1,clr2

; *****
; Write out to kld form
   iwrkld=1
  if (iwrkld eq 1) then begin

    vec2=fltarr(2)
    printf,iout,'  '

    if (ii eq 0) then begin
     printf,iout,'  '
     printf,iout,'  real index'
     printf,iout,'  i,wavel,real,'
    endif
    if (ii eq 1) then begin
     printf,iout,'  '
     printf,iout,'  imaginary index'
     printf,iout,'  i,wavel,imaginary,'
    endif
   for i=0,ntot-1 do begin
    printf,iout,format='(1(1x,i4,","),1(1x,f10.4,","),4(1x,f10.4,","))',$
     i,xvec(i),yvec(i)
   endfor
  endif

; *****

    endfor
; Loop over the graphs

; Close the output ps graphics file
    print,' compareindx: wrote to ',fileps
    device,/close

    stop

; *************************
  return
  end
