  subroutine wrext(nopr,iout,outdir,iwave,&
  nwave,wave,bext,babs,bsca,asym,omega)

! *************************
  integer :: nopr,iout,idat,noprf

! See rdinoutdir.f90
  character(len=60) :: outdir

! See getfilnm30.f90
  character(len=30) :: fil
  character(len=100) :: filnm

! See calcext.f90
  integer :: iwave
  integer :: nwave
  real :: wave(nwave)
  real :: bext(nwave),babs(nwave)
  real :: bsca(nwave),asym(nwave)
  real :: omega(nwave)

! *************************
!     '123456789012345678901234567890'
  fil='ext.ascii                     '
   noprf=1
  call getfilnm30(noprf,iout,fil,outdir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! *************************
! Open the output ascii file for the refractive indices
   idat=30
  open(idat,form='formatted',file=filnm,status='unknown')

  write(0,fmt=190) filnm
  190 format(2x,"Will write to ",/,2x,a100)

! *************************
! Write out to the output ascii file
   write(idat,fmt=200)
   200 format(/,&
   2x,"bext,babs,bsca, are in 1/km units",/,&
   2x,"asym,omega are unitless",/,&
   2x,"i,wavecm,wavelength,bext,babs,bsca,asym,omega")
   do i=1,nwave
    if (iwave .eq. 1) then
     a1=wave(i)
     a2=1.0e4/wave(i)
    end if
    if (iwave .eq. 2) then
     a1=1.0e4/wave(i)
     a2=wave(i)
    end if
    write(idat,fmt=210) i,a1,a2,bext(i),babs(i),bsca(i),asym(i),omega(i)
    210 format(1(1x,i3,","),2(1x,f10.4,","),1p,5(1x,e10.3,","))
   end do

! *************************
! Close the output ascii file
   close (idat)

! *************************
  return
  end
