  subroutine rdmagi_biomass_fire(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=15,mdays=6
  integer :: iday
  integer :: nlinesj(mdays)
  real :: wcmdat(ndat,mdays),wavedat(ndat,mdays)
  real :: rnerr,rierr
! Note that the ndat,nt is opposite to the ncdump dump
  real :: rnval(ndat,mdays),rival(ndat,mdays)
  character(len=60) :: fil
  character (len=16) :: llset,files(mdays)

  data nlinesj/15, 15, 15, 15, 15, 15 /

!         '1234567890123456'
  files(1)=' 1 Aug 22 2000 '
  files(2)=' 2 Aug 24 2000 '
  files(3)=' 3 Aug 31 2000 '
  files(4)=' 4 Sep 3 2000  '
  files(5)=' 5 Sep 6 2000  '
  files(6)=' 6 Sep 6 2000  '

! ***
! Will specify which day to work with

   write(0,fmt=130) 
   130 format(2x,"These are the days to work with for the Magi data")
  do i=1,6 
   write(0,fmt=135) i,files(i)
   135 format(2x,i3,2x,a16)
  end do

  write(0,fmt=140)
  140 format(2x," Will select day to work with (1-6) ")

  write(0,fmt=160)
  160 format(2x,"Specify iday ")

  read(5,*) iday
  iday=int(iday)

! The compound string
  llset=files(iday)

  write(0,fmt=170) iday,llset
  170 format(2x," iday,llset ",i4,2x,a16)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/magi_biomass_fire.dat                          '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! *****
! Data: Real and imaginary indices of biomass burning aerosol retrieved
! from SAFARI field campaign data, from 354 - 1557 nm

! Reference: B. J. Magi, Q. Fu, and Redemann, A methodology to retrieve
! self-consistent aerosol properties using common aircraft measurements
! J. Geophys. Res., vol 112, D24S12, doi:10.1029/2006JD008312, 2007

! Contact: Steven Massie (Steven.Massie@lasp.colorado.edu)

! ID 1 22 Aug 2000
! ID 2 24 Aug 2000
! ID 3 31 Aug 2000
! ID 4 3 Sep 2000
! ID 5 6 Sep 2000
! ID 6 6 Sep 2000

! Contact: S. T. Massie (massie@ucar.edu)
!
! Format: 15 lines 2x,2(1x,f8.2),4(1x,f10.4)
!         The realerr and imaginaryerr are  errors
!
!  ID 1 22 Aug 2000
!      cm-1    microns     real    imaginary   realerr imaginaryerr
!   28248.59     0.35     1.5500     0.0130     0.0100     0.0020
!   26315.79     0.38     1.5300     0.0120     0.0100     0.0020

! *****
! read in all of the data
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,21
   read(idat,fmt=100) header
  end do
  100 format(a80)

  do j=1,mdays

   nskip=3
  do i=1,nskip
   read(idat,fmt=100) header
  end do

   nlines=nlinesj(j)
  do i=1,nlines
   read(idat,*) wcmdat(i,j),wavedat(i,j),rnval(i,j),rival(i,j),rnerr,rierr
  end do

  end do

  close (idat)

! *****
! Put values into the output arrays
   j=iday
  do i=1,nlines
   wcm(i)=wcmdat(i,j)
   wavelength(i)=wavedat(i,j)
   rndat(i)=rnval(i,j)
   ridat(i)=rival(i,j)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=829) iday,files(iday)
    829 format(/,2x,"rdmagi_biomass_fire: iday,files(iday) ",i4,2x,a16)
    write(iout,fmt=830) nlines
    830 format(/,2x,"rdmagi_biomass_fire: nlines ",i4)
    write(iout,fmt=840)
    840 format(/,2x,"rdmagi_biomass_fire: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
