  subroutine rdliu_soa_est(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=200,nlab=3
  integer,parameter :: nlines1=155,nlines2=195,nlines3=195
  integer :: noprf,ilab
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat,3),rival(ndat,3)
  character(len=60) :: fil
  character(len=50) :: labstr(nlab)
  character(len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

!       '1234567890123456'
  llset='liu_soa_est     '

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/liu_soa_est.dat                                '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****
!  Reference: Pengfei Liu, Yue Zhang, and Scot T. Martin
!  Complex Refractive Indices of Thin Films of Secondary Organic
!  Materials by Spectroscopic Ellipsometry from 220 to 1200 nm
!  Env. Sci. Teach., volume 47, 13594-13601, 2013
!  dx.doi.org/10.1021/es403411e

!  Real and Imaginary Refractive Indices of SOA Aerosol

!  Contact: S. T. Martin (scot_martin@harvard.edu)

!  Laboratory conditions
!     1  alpha pinene
!     2  limonene
!     3  catechol

!   alpha pinene
!   nlines      155
!   i,wcm(i),wavelength(i),rn(i),ri(i)
!     1 43478.2617     0.2300     1.5978     0.0065


! *****
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,11
   read(idat,fmt=100) header
  end do
  100 format(a80)

  do i=1,nlab
   read(idat,fmt=102) labstr(i)
  end do
  102 format(a50)

   do i=1,4
    read(idat,fmt=100) header
   end do
    j=1
   do i=1,nlines1
    read(idat,*) k,wcmdat(i),wavedat(i),rnval(i,j),rival(i,j)
   end do

   do i=1,4
    read(idat,fmt=100) header
   end do
    j=2
   do i=1,nlines2
    read(idat,*) k,wcmdat(i),wavedat(i),rnval(i,j),rival(i,j)
   end do

   do i=1,4
    read(idat,fmt=100) header
   end do
    j=3
   do i=1,nlines3
    read(idat,*) k,wcmdat(i),wavedat(i),rnval(i,j),rival(i,j)
   end do

  close (idat)

! *****
! Will select the labooratory condition to work with
  do i=1,nlab
   write(0,fmt=102) labstr(i)
  end do

  write(0,fmt=140)
  140 format(2x,"Specify ilab 1 to 3")
  read(5,*) ilab

  write(0,fmt=165) ilab
  165 format(2x," will use ilab ",i2)

! *****
! Put values into the output arrays
   if (ilab .eq. 1) then 
    nlines=nlines1
   endif
   if (ilab .eq. 2) then 
    nlines=nlines2
   endif
   if (ilab .eq. 3) then 
    nlines=nlines3
   endif

  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i,ilab)
   ridat(i)=rival(i,ilab)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rdliu_soa_est: nlines,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rdliu_soa_est: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end


