  subroutine rdinoutdir(nopr,iout,indir,outdir,fout)

! *****
! Read in the specifications of the input refractive index and output
! subdirectory to which output text and ps graphs are written to
! Information is supplied by the user in the    directory.dat   file

  character(len=13) :: file
  character(len=5) :: fout
  character(len=80) :: header1,header2,header3,header4
  character(len=80) :: blankline
  character(len=60) :: indir,outdir
  integer :: nopr,iout,idat

! *************************
! The directory.dat ascii file specifies the directory that
! has the indices of refraction, and the directory to which
! text and ps graphs are written to.

!       '1234567890123'
   file='directory.dat'

! *************************
! The directory.dat file is on logical unit idat
    idat=30
  open(idat,form='formatted',file='directory.dat',status='unknown')

  read(idat,fmt=100) header1
  read(idat,fmt=110) indir
  read(idat,fmt=100) blankline

  read(idat,fmt=100) header2
  read(idat,fmt=110) outdir
! read(idat,fmt=100) blankline

  100 format(a80)
  110 format(a60)
  120 format(a60)

! Close the directory.dat file
   close (idat)

! *************************
! Write out to the output ascii file
  if (nopr .eq. 1) then

  write(iout,fmt=200)

  write(iout,fmt=210)
  write(iout,fmt=220) fout

  write(iout,fmt=230)
  write(iout,fmt=240) outdir

  write(iout,fmt=250)
  write(iout,fmt=240) indir

  200 format(/)

  210 format(2x,"rdinoutdir: the output ascii text file is ")
  220 format(2x,a5)
  230 format(2x,"rdinoutdir:  output text, graphics files are at")
  240 format(2x,a60)
  250 format(2x,"rdinoutdir:  the input indices files are located at ")

  end if

! *****
! stop 'rdinoutdir: done'

! *****
 return
 end
