  subroutine samewave(nopr,iout,&
  nlines,wcm,wavelength,&
  nlinesr,wcmr,wavelengthr,rndat,&
  nlinesi,wcmi,wavelengthi,ridat)

! *************************
! Has max number of output wavelengths (or indices)
  include 'param1.inc'

! See rdindices.f90
  character(len=100) :: lset
  integer :: nlinesr,nlinesi,nlines
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)

! For cases in which the number of real and imaginary indices differ
  real :: rndat2(nwavemax),ridat2(nwavemax)
  real :: wcmr(nwavemax),wavelengthr(nwavemax)
  real :: wcmi(nwavemax),wavelengthi(nwavemax)

! *************************
! Put values into temporary rndat2 and ridat2 arrays
    do i=1,nlinesr
     rndat2(i)=rndat(i)
    end do

    do i=1,nlinesi
     ridat2(i)=ridat(i)
    end do

! *************************
! Note ranges to work with
     wavelminr=1.0e6
     wavelmaxr=-1.0e6
    do i=1,nlinesr
     if (wavelengthr(i) .lt. wavelminr) then 
      wavelminr=wavelengthr(i)
     end if
     if (wavelengthr(i) .gt. wavelmaxr) then 
      wavelmaxr=wavelengthr(i)
     end if
    end do

     wavelmini=1.0e6
     wavelmaxi=-1.0e6
    do i=1,nlinesi
     if (wavelengthi(i) .lt. wavelmini) then 
      wavelmini=wavelengthi(i)
     end if
     if (wavelengthi(i) .gt. wavelmaxi) then 
      wavelmaxi=wavelengthi(i)
     end if
    end do

  write(0,fmt=130) nlinesi,nlinesr
  130 format(2x,"samewave: wnlinesi,nlinesr ",2(1x,i4))
  write(0,fmt=140) wavelmini,wavelminr
  140 format(2x,"samewave: wavelmini,wavelminr ",2(1x,f10.4))
  write(0,fmt=142) wavelmaxi,wavelmaxr
  142 format(2x,"samewave: wavelmaxi,wavelmaxr ",2(1x,f10.4))

! Note that the data may not have increasing wavelength
  write(0,fmt=144) wavelengthi(1),wavelengthi(nlinesi)
  144 format(2x,"samewave: wavelengthi(1),wavelengthi(nlinesi) ",2(1x,f10.4))
  write(0,fmt=146) wavelengthr(1),wavelengthr(nlinesr)
  146 format(2x,"samewave: wavelengthr(1),wavelengthr(nlinesr) ",2(1x,f10.4))

  wimag1st=wavelengthi(1)
  wimaglast=wavelengthi(nlinesi)

  wreal1st=wavelengthr(1)
  wreallast=wavelengthr(nlinesi)

! ******
! Case where imaginary wavelength range is less than real range
! e.g. rdmyhre_organic_acids.f90
   if ((wavelmini .le. wavelminr) .and. (wavelmaxi .le. wavelmaxr)) then
   if ((wimag1st .gt. wimaglast) .and. (wreallist .gt. wreallast)) then

       icalc=0
      write(0,fmt=150) icalc
  150 format(2x,"samewave: icalc ",i4)

     do i=nlinesi,1,-1 
      if (wavelengthi(i) .ge. wavelengthr(1)) then 
       istart=i
       stop
       go to 600
      end if
     end do
     600 mn=0

! **
      nlines=nlinesi-istart+1
      write(0,fmt=152) icalc,nlines,nlinesi,istart
  152 format(2x,"samewave: icalc,nlines,nlinesi,istart ",/,&
      2x,4(1x,i4))

      stop

! **
! The imaginary values are the primary ones to work with
      m=istart-1
     do i=1,nlines 
       m=m+1
      ridat(i)=ridat2(m)
      wcm(i)=wcmi(m)
      wavelength(i)=wavelengthi(m)
     end do

! **
! Find first match
       i=1
      diffmin=1.0e6
      istart=-99
     do ii=1,nlinesr 
      diff=abs(wavelengthr(ii)-wavelength(i))
      if (diff .lt. diffmin) then
       istart=ii
       diffmin=diff
      end if
     end do

      iwrsp=0
     if (iwrsp .eq. 1) then
      write(iout,fmt=5000) i,istart,diffmin,&
      wavelengthr(istart),wavelength(i)
      5000 format(2x,"samewave: i,istart,diffmin ",&
      2(1x,i4),1p,1(1x,e10.3),/,&
      2x,"samewave: wavelengthr(istart),wavelength(i) ",2(1x,e10.3),/,&
      2x,"samewave: i,ii,rndat(i) ")
     end if

! **
! Specify the rndat values
      idiff=5
      ii=istart
     do i=1,nlines 

       j1=ii-idiff
       j2=ii+idiff
      if (j1 .lt. 1) then
       j1=1
      end if
      if (j2 .ge. nlinesr) then
       j2=nlinesr
      end if
 
       diffmin=1.0e6
       iuse=-99
      do j=j1,j2 
       diff=abs(wavelengthr(j)-wavelength(i))
       if (diff .lt. diffmin) then
        iuse=j
        ii=j
        diffmin=diff
       end if
      end do

       rndat(i)=0.0
      if ((iuse .ge. 1) .and. (iuse .le. nlinesr)) then 
       rndat(i)=rndat2(iuse)
      end if 

      if (iwrsp .eq. 1) then 
       write(iout,fmt=5010) i,iuse,rndat(i)
       5010 format(2x,2(1x,i4),1p,1(1x,e10.3))
      endif

      end do
! loop over nlines

     go to 1000

   end if
   end if

! ********
! Case where imaginary wavelength range is less than real range
! e.g. rdliu_soa_acp.f90
   if ((wavelmini .le. wavelminr) .and. (wavelmaxi .le. wavelmaxr)) then
   if ((wimag1st .le. wimaglast) .and. (wreallist .le. wreallast)) then

       icalc=1
      write(0,fmt=150) icalc
! 150 format(2x,"samewave: icalc ",i4)

     do i=1,nlinesi 
      if (wavelengthi(i) .ge. wavelengthr(1)) then 
       istart=i
       stop
       go to 700
      end if
     end do
     700 mn=0

! **
      nlines=nlinesi-istart+1
      write(0,fmt=152) icalc,nlines,nlinesi,istart
! 152 format(2x,"samewave: icalc,nlines,nlinesi,istart ",/,&
!     2x,4(1x,i4))

! **
! The imaginary values are the primary ones to work with
      m=istart-1
     do i=1,nlines 
       m=m+1
      ridat(i)=ridat2(m)
      wcm(i)=wcmi(m)
      wavelength(i)=wavelengthi(m)
     end do

! **
! Find first match
       i=1
      diffmin=1.0e6
      istart=-99
     do ii=1,nlinesr 
      diff=abs(wavelengthr(ii)-wavelength(i))
      if (diff .lt. diffmin) then
       istart=ii
       diffmin=diff
      end if
     end do

      iwrsp=0
     if (iwrsp .eq. 1) then
      write(iout,fmt=5000) i,istart,diffmin,&
      wavelengthr(istart),wavelength(i)
!     5000 format(2x,"samewave: i,istart,diffmin ",&
!     2(1x,i4),1p,1(1x,e10.3),/,&
!     2x,"samewave: wavelengthr(istart),wavelength(i) ",2(1x,e10.3),/,&
!     2x,"samewave: i,ii,rndat(i) ")
     end if

! **
! Specify the rndat values
      idiff=5
      ii=istart
     do i=1,nlines 

       j1=ii-idiff
       j2=ii+idiff
      if (j1 .lt. 1) then
       j1=1
      end if
      if (j2 .ge. nlinesr) then
       j2=nlinesr
      end if
 
       diffmin=1.0e6
       iuse=-99
      do j=j1,j2 
       diff=abs(wavelengthr(j)-wavelength(i))
       if (diff .lt. diffmin) then
        iuse=j
        ii=j
        diffmin=diff
       end if
      end do

       rndat(i)=0.0
      if ((iuse .ge. 1) .and. (iuse .le. nlinesr)) then 
       rndat(i)=rndat2(iuse)
      end if 

      if (iwrsp .eq. 1) then 
       write(iout,fmt=5010) i,iuse,rndat(i)
!      5010 format(2x,2(1x,i4),1p,1(1x,e10.3))
      endif

      end do
! loop over nlines

     go to 1000

   end if
   end if

! ******
! Case where imaginary wavelength range is less than real range
! e.g. rdliu_soa_acp.f90
   if ((wavelmini .ge. wavelminr) .and. (wavelmaxi .le. wavelmaxr)) then

     icalc=2
    write(0,fmt=150) icalc

! **
      nlines=nlinesi

! **
! The imaginary values are the primary ones to work with
     do i=1,nlines 
      ridat(i)=ridat2(i)
      wcm(i)=wcmi(i)
      wavelength(i)=wavelengthi(i)
     end do

! **
! Find first match
      i=1
      diffmin=1.0e6
      istart=-99
     do ii=1,nlinesr 
      diff=abs(wavelengthr(ii)-wavelength(i))
      if (diff .lt. diffmin) then
       istart=ii
       diffmin=diff
      end if
     end do

      iwrsp=0
     if (iwrsp .eq. 1) then
      write(iout,fmt=5000) i,istart,diffmin,&
      wavelengthr(istart),wavelength(i)
!     5000 format(2x,"samewave: i,istart,diffmin ",&
!     2(1x,i4),1p,1(1x,e10.3),/,&
!     2x,"samewave: wavelengthr(istart),wavelength(i) ",2(1x,e10.3),/,&
!     2x,"samewave: i,ii,rndat(i) ")
     end if

! **
! Specify the rndat values
      idiff=5
      ii=istart
     do i=1,nlines 

       j1=ii-idiff
       j2=ii+idiff
      if (j1 .lt. 1) then
       j1=1
      end if
      if (j2 .ge. nlinesr) then
       j2=nlinesr
      end if
 
       diffmin=1.0e6
       iuse=-99
      do j=j1,j2 
       diff=abs(wavelengthr(j)-wavelength(i))
       if (diff .lt. diffmin) then
        iuse=j
        ii=j
        diffmin=diff
       end if
      end do

       rndat(i)=0.0
      if ((iuse .ge. 1) .and. (iuse .le. nlinesr)) then 
       rndat(i)=rndat2(iuse)
      end if 

      if (iwrsp .eq. 1) then 
       write(iout,fmt=5010) i,iuse,rndat(i)
!      5010 format(2x,2(1x,i4),1p,1(1x,e10.3))
      endif

      end do
! loop over nlines

     go to 1000

   end if

! *************************
! Previous 
    if (nlinesi .lt. nlinesr) then 

     icalc=3
    write(0,fmt=150) icalc

! **
      nlines=nlinesi

! **
! The imaginary values are the primary ones to work with
     do i=1,nlines 
      ridat(i)=ridat2(i)
      wcm(i)=wcmi(i)
      wavelength(i)=wavelengthi(i)
     end do

! **
! Find first match
      i=1
      diffmin=1.0e6
      istart=-99
     do ii=1,nlinesr 
      diff=abs(wavelengthr(ii)-wavelength(i))
      if (diff .lt. diffmin) then
       istart=ii
       diffmin=diff
      end if
     end do

      iwrsp=0
     if (iwrsp .eq. 1) then
      write(iout,fmt=5000) i,istart,diffmin,&
      wavelengthr(istart),wavelength(i)
!     5000 format(2x,"samewave: i,istart,diffmin ",&
!     2(1x,i4),1p,1(1x,e10.3),/,&
!     2x,"samewave: wavelengthr(istart),wavelength(i) ",2(1x,e10.3),/,&
!     2x,"samewave: i,ii,rndat(i) ")
     end if

! **
! Specify the rndat values
      idiff=5
      ii=istart
     do i=1,nlines 

       j1=ii-idiff
       j2=ii+idiff
      if (j1 .lt. 1) then
       j1=1
      end if
      if (j2 .ge. nlinesr) then
       j2=nlinesr
      end if
 
       diffmin=1.0e6
       iuse=-99
      do j=j1,j2 
       diff=abs(wavelengthr(j)-wavelength(i))
       if (diff .lt. diffmin) then
        iuse=j
        ii=j
        diffmin=diff
       end if
      end do

       rndat(i)=0.0
      if ((iuse .ge. 1) .and. (iuse .le. nlinesr)) then 
       rndat(i)=rndat2(iuse)
      end if 

      if (iwrsp .eq. 1) then 
       write(iout,fmt=5010) i,iuse,rndat(i)
!      5010 format(2x,2(1x,i4),1p,1(1x,e10.3))
      endif

      end do

      go to 1000

    end if

! *************************
    if (nlinesr .lt. nlinesi) then

     icalc=4
    write(0,fmt=150) icalc

! **
      nlines=nlinesr

! **
! The real values are the primary ones to work with
     do i=1,nlines
      rndat(i)=rndat2(i)
      wcm(i)=wcmr(i)
      wavelength(i)=wavelengthr(i)
     end do

! **
! Find first match
      diffmin=1.0e6
      i=1
     do ii=1,nlinesi
      diff=abs(wavelengthi(ii)-wavelength(i))
      if (diff .lt. diffmin) then
       istart=ii
       diffmin=diff
      end if
     end do

! **
! Specify the ridat values
      idiff=5
      ii=istart
     do i=1,nlines

       j1=ii-idiff
       j2=ii+idiff
      if (j1 .lt. 1) then 
       j1=1
      end if
      if (j2 .ge. nlinesi) then
       j2=nlinesi
      end if
 
       iuse=-99
       diffmin=1.0e6
      do j=j1,j2 
       diff=abs(wavelengthi(j)-wavelength(i))
       if (diff .lt. diffmin) then
        iuse=j
        ii=j
        diffmin=diff
       end if
      end do

       ridat(i)=0.0
      if ((iuse .ge. 1) .and. (iuse .le. nlinesi)) then 
       ridat(i)=ridat2(iuse)
      end if

      end do

      go to 1000

    end if

    1000 mn=0

! *************************
! Make sure ridat is ge 0.0
   do i=1,nlines 
    a1=ridat(i)
    if (a1 .lt. 0.0) then 
     ridat(i)=0.0
    end if
   end do

! *************************
! Write out the results

  if (nopr .eq. 1) then

    write(iout,fmt=500) nlines,nlinesr,nlinesi,icalc
    500 format(/,&
    2x,"samewave: nlines,nlinesr,nlinesi ",/,&
    2x,4(2x,i4),/,&
    2x,"samewave: i,wavelength(i),wcm(i),rndat(i),ridat(i)")
     i=1
    write(iout,fmt=510) i,wavelength(i),wcm(i),rndat(i),ridat(i)
    510 format(2x,i4,2x,2(1x,f10.4),1p,2(1x,e10.3))
     i=nlines
    write(iout,fmt=510) i,wavelength(i),wcm(i),rndat(i),ridat(i)

    write(iout,fmt=500) nlines,nlinesr,nlinesi
   do i=1,nlines 
    write(iout,fmt=510) i,wavelength(i),wcm(i),rndat(i),ridat(i)
   end do

  end if

    write(iout,fmt=500) nlines,nlinesr,nlinesi

! *************************
  return
  end
