   subroutine rdliu_soa_acp(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,&
   nlinesr,wcmr,wavelengthr,rndat,&
   nlinesi,wcmi,wavelengthi,ridat,&
   ndifferent,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndati=571,ndatr=93,nlab=9
  integer :: noprf,ilab
  real :: wcmr(nwavemax),wavelengthr(nwavemax),rnval(ndatr,8)
  real :: wcmi(nwavemax),wavelengthi(nwavemax),rival(ndati,8)
  character(len=60) :: fil
  character(len=50) :: labstr(nlab)
  character(len=16) :: llset

  nlinesr=ndatr
  nlinesi=ndati

! ***
! Read in the data from the ascii file
   lset=lstrn

!       '1234567890123456'
  llset='liu soa acp     '

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/liu_soa_ACP2015.dat                            '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****
! Reference: P. F. Liu, N. Abdelmalki, H.-M. Hung, Y. Wang, W. H. Brune
! and S. T. Martin
! Ultraviolet and visible complex refractive indices of secondary
! organic material produced by photooxidation of the aromatic compounds
! toluene and m-xylene
! Atmos. Chem. Phys., 15, 1435–1446, 2015
! www.atmos-chem-phys.net/15/1435/2015/
! doi:10.5194/acp-15-1435-2015

! Real and Imaginary Refractive Indices of SOA Aerosol

! Contact: S. T. Martin (scot_martin@harvard.edu)

! Laboratory conditions
!    1  A1   toulene   5.0        0.0            n/a
!    2  A2   toulene   5.0        2.5            14
!    3  A3   toulene   5.0        5.0            7.0
!    4  A4   toulene   5.0       10.0            3.5
!    5  B1   m-xylene  5.0        0.0            n/a
!    6  B2   n-xylene  5.0        2.5            16
!    7  B3   n-xylene  5.0        5.0            8.0
!    8  B4   n-xylene  5.0       10.0            4.0
!    ilab            HC0(ppm)   NO0(ppm)   NC0/NO0 (ppbc ppN-1)

!  nlines      571
!  i,wcmnk(i),wavelengthk(i),rkA1(i),rkA2(i),rkA3(i),rkA4(i),rkB1(i),rkB2(i),rkB3(i),rkB4(i)
!    1 43478.2617     0.2300     0.2281     0.1674     0.2092     0.1778
!0.2281     0.1674     0.2092     0.1778
!    2 43290.0430     0.2310     0.2316     0.1638     0.2095     0.1599
!0.2316     0.1638     0.2095     0.1599
!    3 43103.4453     0.2320     0.2323     0.1613     0.2113     0.1455
!0.2323     0.1613     0.2113     0.1455
!    4 42918.4531     0.2330     0.2292     0.1596     0.2138     0.1342
!0.2292     0.1596     0.2138     0.1342
!    5 42735.0391     0.2340     0.2228     0.1581     0.2167     0.1250
!0.2228     0.1581     0.2167     0.1250
!    6 42553.1875     0.2350     0.2144     0.1566     0.2192     0.1176
!0.2144     0.1566     0.2192     0.1176
!    7 42372.8789     0.2360     0.2061     0.1548     0.2210     0.1117
!0.2061     0.1548     0.2210     0.1117

!  570 12515.6445     0.7990     0.0003    -0.0001     0.0001     0.0002
!0.0003    -0.0001     0.0001     0.0002
!  571 12500.0000     0.8000     0.0001     0.0001    -0.0003    -0.0003
!0.0001     0.0001    -0.0003    -0.0003
!
!!  nlines       93
!  i,wcmn(i),wavelengthn(i),rnA1(i),rnA2(i),rnA3(i),rnA4(i),rnB1(i),rnB2(i),rnB3(i),rnB4(i)
!    1 35714.2852     0.2800     1.5820     1.5829     1.6009     1.6023
!1.5820     1.5829     1.6009     1.6023
!    2 34482.7578     0.2900     1.5780     1.5794     1.5968     1.5996
!1.5780     1.5794     1.5968     1.5996
!    3 33333.3320     0.3000     1.5742     1.5762     1.5928     1.5968
!1.5742     1.5762     1.5928     1.5968
!    4 32258.0645     0.3100     1.5706     1.5731     1.5890     1.5940
!1.5706     1.5731     1.5890     1.5940
!    5 31249.9980     0.3200     1.5673     1.5702     1.5854     1.5912
!1.5673     1.5702     1.5854     1.5912

! *****
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,14
   read(idat,fmt=100) header
  end do
  100 format(a80)

  do i=1,nlab
   read(idat,fmt=102) labstr(i)
  end do
  102 format(a50)

   do i=1,3
    read(idat,fmt=100) header
   end do
   do i=1,nlinesi
    read(idat,*) j,wcmi(i),wavelengthi(i),(rival(i,j),j=1,8)
   end do

   do i=1,3
    read(idat,fmt=100) header
   end do
   do i=1,nlinesr
    read(idat,*) j,wcmr(i),wavelengthr(i),(rnval(i,j),j=1,8)
   end do

  close (idat)

! *****
! Will select the labooratory condition to work with
  do i=1,nlab
   write(0,fmt=102) labstr(i)
  end do

  write(0,fmt=140)
  140 format(2x,"Specify ilab, 1 to 8")
  read(5,*) ilab

  write(0,fmt=165) ilab
  165 format(2x," will use ilab ",i2)

! *****
! Put values into the output arrays
  do i=1,nlinesr
   rndat(i)=rnval(i,ilab)
  end do

  do i=1,nlinesi
   ridat(i)=rival(i,ilab)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlinesr,fil
   200 format(/,2x,"rdliu_soa_acp: nlinesr,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rdliu_soa_acp: i,wcmr,wavelengthr,rndat")
   do i=1,nlinesr
    write(iout,fmt=240) i,wcmr(i),wavelengthr(i),rndat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,1(1x,e10.3))
   end do

   write(iout,fmt=202) nlinesi,fil
   202 format(/,2x,"rdliu_soa_acp: nlinesi,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=232)
   232 format(2x,"rdliu_soa_acp: i,wcmi,wavelengthi,ridat")
   do i=1,nlinesi
    write(iout,fmt=240) i,wcmi(i),wavelengthi(i),ridat(i)
   end do

  end if

! ******
  return
  end
