  subroutine rddeguine_ash(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=228,nsets=6
  integer :: noprf
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat,nsets),rival(ndat,nsets)
  character(len=60) :: fil
  character(len=50) :: setsstr(nsets)
  character(len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

!       '1234567890123456'
  llset='deguine_ash     '

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/deguine_ash.dat                                '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

  nlines=ndat

! *****
! Reference: Alexandre Deguine, Denis Petitprez, Lieven Clarisse,
! Snaevarr Gudmundsson, Valeria Outes, Gustavo Villarosa, Herve Herbin
! Complex refractive index of volcanic ash aerosol in the infrared,
! visiblem and ultraviolet
! Applied Optics, volume 59, No. 4, 884-895, 2020
! https://doi.org/10.1364/AO.59.000884

! Real and Imaginary Refractive Indices of Volcanic Ash
!
! Contact: Alexandre Deguine (adeguine@ulb.ac.be)

! Samples
!  Calbuco
!  Chaiten
!  Etna
!  Eyja
!  Grimsvotn
!  Puyehue

!  nlines      228
!  i,wcm(i),wavelength(i),rn(i,j),j=1,6
!     0     0.6900 14492.7539    2.005000    1.787000    1.796000    1.891000
! 1.854000    1.870000

! *****
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,12
   read(idat,fmt=100) header
  end do
  100 format(a80)

  do i=1,nsets
   read(idat,fmt=102) setsstr(i)
  end do
  102 format(a50)

   do i=1,3
    read(idat,fmt=100) header
   end do
    j=1
   do i=1,nlines
    read(idat,*) k,wavedat(i),wcmdat(i),(rnval(i,j),j=1,6)
   end do

   do i=1,3
    read(idat,fmt=100) header
   end do
    j=1
   do i=1,nlines
    read(idat,*) k,wavedat(i),wcmdat(i),(rival(i,j),j=1,6)
   end do

  close (idat)

! *****
! Will select the labooratory condition to work with
  do i=1,nsets
   write(0,fmt=104) i,setsstr(i)
  end do
  104 format(2x,i2,2x,a50)

  write(0,fmt=140)
  140 format(2x,"Specify iset 1 to 6")
  read(5,*) iset

  write(0,fmt=165) iset
  165 format(2x," will use iset ",i2)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i,iset)
   ridat(i)=rival(i,iset)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rddeguine: nlines,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rddeguine: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end
