  subroutine rdchang_flame_soot(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ******
! Read in the data from the ascii file

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=13,ncomp=3
  integer :: noprf,mset,itemp,i1,i2
  real :: wcmdat(ndat),wavedat(ndat)
  real :: rnval(ndat,ncomp),rival(ndat,ncomp)
  character(len=60) :: fil
  character (len=16) :: files(ncomp),llset

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/chang_flame_soot.dat                           '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
!
! Data: Real and imaginary indices of refraction of flame soot
! from 0.20 to 38.4 microns at three heights (in mm) above the flame

! Reference: H. Chang and T. T. Charalampopoulis, Determination of the
! Wavelength Dependence of Refractive Indices of Flame Soot
! Proc. R. Soc. London A 1990, v430, 577-591, doi:10.198/rspa.1990.0107

! Contact: Steven Massie (Steven.Massie@lasp.colorado.edu)

! Format: 13 lines 2x,2(1x,f8.2),3(1x,f10.4)
!         13 lines 2x,2(1x,f8.2),3(1x,f10.4)
!
!      cm-1    microns                 real
!                          6 mm        8 mm       10 mm
!   50000.00     0.20     0.7800     0.8200     0.9400
!   38461.54     0.26     1.0400     0.9700     1.1900
!   25000.00     0.40     1.5000     1.6000     1.6400

! Open the input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,12
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=ndat

   do i=1,3
    read(idat,fmt=100) header
   end do
   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rnval(i,j),j=1,ncomp)
   end do

   do i=1,3
    read(idat,fmt=100) header
   end do
   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rival(i,j),j=1,ncomp)
   end do

  close (idat)

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! The different compositions
!          '1234567890123456'
  files(1)=' 6 mm           '
  files(2)=' 8 mm           '
  files(3)=' 10 mm          '

! *
! Write out the compounds included in the ascii file
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific measurement")
  write(0,fmt=145)
  145 format(2x," i, height in mm above flame")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-3) e.g. mset=1 for 8 mm case ")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=files(mset)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i,mset)
   ridat(i)=rival(i,mset)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) mset,files(mset)
    800 format(/,2x,"rdchang_flame_soot: work with mset, files(mset)",/,&
    2x,i3,2x,a16)
    write(iout,fmt=840)
    840 format(2x,"rdchang_flame_soot: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines 
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end


