#!/bin/bash
# Script to build multiple AHEF input files and run automatically

#----------------------------------------------------------
#1) compile code afresh
#----------------------------------------------------------
cd SOURCE_f90
  make AHEF
cd ../

inpdir="RUN_INPUT"
inpfile="AHEF_RUN.INP"

globfile="WMO2010"
frffile="WMO2018"
taufile="WMO2018"

#----------------------------------------------------------
#2) set emissions scenario
#----------------------------------------------------------
for scenario in  "WMO_A1"  ; do
#for scenario in "WMO_A1 WMO_NoCntl  WMO_MP" ; do
#for incrfile in "SAP19_to2020 SAP19_to2025 QPS_2020_v2 QPS_2025_v2 SAP19_const" ; do
#for incrfile in "QPS_2020_v3 QPS_2025_v3" ; do
#for incrfile in "SAP19_to2020_v3 SAP19_to2025_v3" ; do
#for incrfile in "QPS_2059 QPS_2100" ; do
#for incrfile in "SAP19_to2025 SAP19_to2020" ; do# QPS_2058 QPS_2100" ; do
#for incrfile in "SAP19_const SAP19_to2025 SAP19_to2020" ; do# QPS_2058 QPS_2100" ; do

#----------------------------------------------------------
#3) do desired simulations for each endpoint & o/p selection
#----------------------------------------------------------
#for endpoint in "UVI" "UVNORM" ; do
#for endpoint in "MELAINC" "MELAMORT" "BASAL" "SQUAMOUS" "NMSCMORT" "CATARACT" ; do
for endpoint in "CATARACT" ; do
#for scenario in "WMO_A1" ; do  # "WMO_NoCntl"  "WMO_MP" ; do

for bycty in "TRUE" ; do
for bypop in "TRUE" ; do
for byage in "TRUE" ; do
for byyr  in "TRUE" ; do

  set ageadj = "none"
  #set ageadj = "WHO_std"
  #set ageadj = "USA_2000"

  echo '* AHEF_RUN.INP ' > $inpdir'/'$inpfile
#  echo 'TEST  FALSE '   >> $inpdir'/'$inpfile
  echo 'TEST  TRUE '   >> $inpdir'/'$inpfile
  echo 'RUNOZN  FALSE ' >> $inpdir'/'$inpfile
  echo 'RUNEXP  FALSE ' >> $inpdir'/'$inpfile
  echo 'RUNEFF  TRUE ' >> $inpdir'/'$inpfile
  echo 'GLOB '$globfile'.GLOB' >> $inpdir'/'$inpfile
  echo 'FRF '$frffile'.FRF' >> $inpdir'/'$inpfile
  echo 'TAU '$taufile'.TAU' >> $inpdir'/'$inpfile
  echo 'SCEN '$scenario'.EMI' >> $inpdir'/'$inpfile
#  echo 'INCR '$incrfile'.EMI' >> $inpdir'/'$inpfile
  echo 'ENDPT '$endpoint >> $inpdir'/'$inpfile
  echo 'AGEADJ '$ageadj >> $inpdir'/'$inpfile
  echo 'COHYRF 1890'  >> $inpdir'/'$inpfile
  echo 'COHYRL 2100'  >> $inpdir'/'$inpfile
#  echo 'OUTYRF 1890'  >> $inpdir'/'$inpfile # FOR COHORT CALCS
  echo 'OUTYRF 1980'  >> $inpdir'/'$inpfile # FOR YEAR CALCS
#  echo 'OUTYRL 2000'  >> $inpdir'/'$inpfile # FOR YEAR CALCS
  echo 'OUTYRL 2020'  >> $inpdir'/'$inpfile # FOR YEAR CALCS
#  echo 'OUTYRF 2006'  >> $inpdir'/'$inpfile # FOR PRESENT-DAY CALCS
#  echo 'OUTYRL 2011'  >> $inpdir'/'$inpfile # FOR PRESENT-DAY CALCS 
#  echo 'OUTYRL 2100'  >> $inpdir'/'$inpfile # FOR COHORT CALCS
  echo 'OUTYRD 1'     >> $inpdir'/'$inpfile
  echo 'EXTEND TRUE'  >> $inpdir'/'$inpfile
  echo 'BYYR  '$byyr  >> $inpdir'/'$inpfile
  echo 'BYCTY '$bycty >> $inpdir'/'$inpfile
  echo 'BYAGE '$byage >> $inpdir'/'$inpfile
  echo 'BYPOP '$bypop >> $inpdir'/'$inpfile

  cd SOURCE_f90
    ./AHEF
  cd ../

done
done
done
done
done
done

# ===================================================
# DUMP
# ===================================================
#  echo 'SUPER TRUE'  >> $inpdir'/'$inpfile
#  echo 'REFYR 1962'   >> $inpdir'/'$inpfile
