      SUBROUTINE write_partitionning(chem,name,temp,chatab,ncha)
      IMPLICIT NONE
      include 'general.h'
      include 'common.h'

      CHARACTER(LEN=lco),INTENT(in) :: name
      CHARACTER(LEN=lfo),INTENT(in) :: chem
      REAL, INTENT(in)           :: temp
      INTEGER , INTENT(in)       :: ncha
      CHARACTER(LEN=lco), INTENT(IN):: chatab(10000)

      CHARACTER(LEN=lfo)         :: tchem

      CHARACTER(LEN=lgr)         :: group(mca)
      INTEGER                    :: dbflg, nring
      INTEGER                    :: bond(mca,mca)
      CHARACTER(LEN=lfl)         :: fgrp
      INTEGER                    :: lfg

      LOGICAL                    :: flg
      INTEGER                    :: nc, itest
      REAL                       :: Tb, dB, log10Psat, Trb
      REAL                       :: Nangroup(219)
      REAL                       :: weight
      INTEGER                    :: ic, ih, in, io, ir,is, ifl, ibr, icl
      INTEGER                    :: j
      INTEGER                    :: ndbl

      ndbl = 0
      tchem = chem
      IF (chem(1:3).EQ."#mm".OR.chem(1:3).EQ."#bb") THEN
        tchem = chem(4:)
      ELSE IF (chem(1:1).eq."#") THEN
        tchem = chem(2:)
      ENDIF
! we have to do their aerosol and wall partioning
! except for species for which we can't estimate a vapor pressure
      !IF (pvap_fg.EQ.2 .and. 
      IF (pvap_fg.GE.2 .and. 
     &         tchem(1:5) .ne. "CH2OO" .and.
     &         tchem(1:18) .ne. "CH3C.(OO.)CH2-O-OH" .and.
     &         tchem(1:17) .ne. "CH3C.(OO.)CO-O-OH" .and.
     &         tchem(1:6) .ne. "ethyne" .and.
     &         tchem(1:7) .ne. "propyne" .and.
     &         tchem(1:5) .ne. "GLYOO" .and.
     &         tchem(1:5) .ne. "MGLOO" .and.
     &         tchem(1:6) .ne. "EGLYOO" .and.
     &         tchem(1:5) .ne. "PGLOO" .and.
     &         tchem(1:6) .ne. "IPGLOO" .and.
     &         tchem(1:8) .ne. "BZFUONOO" .and.
     &         tchem(1:8) .ne. "TLFUONOO" .and.
     &         tchem(1:7) .ne. "CATECOO" .and.
     &         tchem(1:8) .ne. "MCATECOO" .and.
     &         tchem(1:8) .ne. "ECATECOO" .and.
     &         tchem(1:8) .ne. "PCATECOO"  .and.
     &         tchem(1:9) .ne. "IPCATECOO" .and.
     &         tchem(1:9) .ne. "OXCATECOO" .and.
     &         tchem(1:9) .ne. "MXCATECOO" .and.
     &         tchem(1:9) .ne. "PXCATECOO" .and.
     &         tchem(1:9) .ne. "OTCATECOO" .and.
     &         tchem(1:9) .ne. "MTCATECOO" .and.
     &         tchem(1:9) .ne. "PTCATECOO" .and.
     &         tchem(1:9) .ne. "T123CTCOO"  .and.
     &         tchem(1:9) .ne. "T124CTCOO" .and.
     &         tchem(1:6) .ne. "PHCHOO" .and.
     &         tchem(1:6) .ne. "CISOPA" .and.
     &         tchem(1:6) .ne. "TISOPA" .and.
     &         tchem(1:5) .ne. "ISOPA" .and.
     &         tchem(1:6) .ne. "CISOPC" .and.
     &         tchem(1:6) .ne. "TISOPC" .and.
     &         tchem(1:5) .ne. "ISOPC" .and.
     &         tchem(1:5) .ne. "CMYRC"  .and.
     &         tchem(1:4) .ne. "MYRC"  .and.
     &         tchem(1:5) .ne. "TMYRC"  .and.
! we can't do these because they have 3 double bonds which bothers cdcase when
! called from nannoolal_tb
! JMLT: see below for more general fix
!     &  tchem(1:37) .ne. "CH3Cd(CH3)=CdHCH2CH2Cd(=CdH2)CdH=CdH2" .and.
!     &  tchem(1:36) .ne. "CH3Cd(CH3)=CdHCH2CdH=Cd(CH3)CdH=CdH2" .and.
     &         tchem(1:10) .ne. "lostcarbon") THEN

!NEW: skip 3-double-bond species unless forced otherwise by pvapcd3_fg
           IF(pvapcd3_fg.NE.1)THEN
             ndbl = COUNT(TRANSFER(tchem,'a',LEN(tchem)) == "=")
             IF(ndbl.GT.2) THEN
               PRINT*,ndbl, tchem
               RETURN
             ENDIF
           ENDIF

        nc = index(tchem,' ') - 1

        CALL grbond(tchem,nc,group,bond,dbflg,nring)
        CALL nannoolal_tb(tchem,group,bond,nring,Tb,Nangroup)
        CALL nannoolal_pvap(tchem,temp,Tb,Nangroup,dB,log10Psat)
        Trb=temp/Tb
        log10Psat = (4.1012+dB)*((Trb-1.)/(Trb-(1./8.)))
         ! write mass transfer equation
        !write aerosol and wall partitioning reactions
        itest=0
        DO j=1,ncha
          IF(name.eq.chatab(j)) THEN
            itest=1
            EXIT
          ENDIF
        ENDDO
!        itest=0 ! turn CHA as a volatile product

        CALL codefg(tchem, fgrp, lfg)
        IF (itest.eq.0) THEN
          CALL molarw_number_withexceptions(tchem,weight, flg,
     &            nc,ic,ih,in,io,ir,is,ifl,ibr,icl)
          IF (aeropart_fg .eq. 1) THEN
            CALL gas2aero(17,tchem,name,Tb,dB,weight,nring)
            IF (aerophot_fg.eq.1 .and. index(tchem, '(OOH)').ne.0) then
              CALL aerphot(name)
            ENDIF
          ENDIF
          IF (wallpart_fg .eq. 1) THEN
            CALL gas2wall(17,tchem,name,Tb,dB,weight)
          ENDIF
        ENDIF
      ENDIF

      END SUBROUTINE
