!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!     ROUTINE STABILIZED CRIEGEE :
!     performs the reactions of the stabilized criegee intermediate :
!     reactions wit H2O, SO2, NO, NO2
!                   CO, HCl, HNO3, O3, NH3, self, unimolecular decomp
!                   avoid reactions with organics for now
!                   no reaction with NH3 becasue it makes amines
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      SUBROUTINE stabilized_criegee_cmv(rdct,bond,group,nring,brch,
     &                 dbrch,dict,namlst,
     &                 cut_off,
     &                 nhldvoc,holdvoc,nhldrad,holdrad,level,stabl,
     &                 nfn,namfn,chemfn)

      IMPLICIT NONE
      INCLUDE 'general.h'
      INCLUDE 'common.h'
      INCLUDE 'organic.h'

! input:
      CHARACTER(LEN=lcf),INTENT(IN) :: rdct
      CHARACTER(LEN=lgr),INTENT(INOUT) :: group(mca)
      INTEGER,INTENT(INOUT)         :: bond(mca,mca)
      INTEGER,INTENT(IN)         :: nring
      REAL,INTENT(IN)            :: brch
      REAL,INTENT(IN)            :: cut_off

! input/output
      CHARACTER(LEN=ldi),INTENT(INOUT) :: dict(mni)
      REAL,INTENT(INOUT)            :: dbrch(mni)
      CHARACTER(LEN=lco),INTENT(INOUT) :: namlst(mni)
      INTEGER,INTENT(INOUT)         :: level
      INTEGER,INTENT(INOUT)         :: stabl
      CHARACTER(LEN=lst),INTENT(INOUT) :: holdvoc(mlv)
      INTEGER,INTENT(INOUT)         :: nhldvoc
      CHARACTER(LEN=lst),INTENT(INOUT) :: holdrad(mra)
      INTEGER,INTENT(INOUT)         :: nhldrad
      INTEGER,INTENT(INOUT)         :: nfn
      CHARACTER(LEN=lco),INTENT(INOUT) :: namfn(mfn)
      CHARACTER(LEN=lfo),INTENT(INOUT) :: chemfn(mfn)

!  internal
      CHARACTER(LEN=lfo) :: pchem, p_carbonyl, p_acid
      CHARACTER(LEN=lgr) :: tgroup(mca), pold, pnew,tempgr
      INTEGER         :: tbond(mca,mca)
      INTEGER         :: ip,i,j,k,nc,nca,cnum,onum
      REAL            :: brtio
      INTEGER         :: np,rjg(mri,2)

      CHARACTER*1     :: a1, a2, a3, a4
      CHARACTER(LEN=lco) :: p(mnp), r(3)
      REAL            :: s(mnp), ar1,ar2,ar3,f298,fratio
      INTEGER         :: idreac, nlabel
      REAL            :: xlabel,folow(3),fotroe(4)
      LOGICAL         :: internal
      INTEGER         :: idci

! CI structures indices
      INTEGER,PARAMETER :: idch2oo = 1 ! CH2OO
      INTEGER,PARAMETER :: idrchoo = 2 ! -CHOO = external CI
      INTEGER,PARAMETER :: idrrcoo = 3 !  >COO = internal CI

! number of CI structures
      INTEGER,PARAMETER :: ncistruct = idrrcoo

! reaction indices
      INTEGER,PARAMETER :: idH2O_1=1, idH2O_2=2, idSO2=3, idNO=4
      INTEGER,PARAMETER :: idNO2=5, idCO=6, idHCl=7, idHNO3=8, idO3=9
      INTEGER,PARAMETER :: idself=10,idunimol=11,idH2O2_1=12,idH2O2_2=13

! number of bimolecular reaction to write=largest reaction index
      INTEGER,PARAMETER :: nbimolreac = idH2O2_2

! reactants and products arrays
      CHARACTER(LEN=lco)   :: reactant(nbimolreac)
      CHARACTER(LEN=lco)   :: coprod(nbimolreac)
      INTEGER           :: idprod(nbimolreac)
      REAL              :: s_coprod(nbimolreac), s_prod(nbimolreac)
      INTEGER,PARAMETER :: id_acid=1, id_carbonyl=2

! reaction rates array
      REAL              :: rate(ncistruct,nbimolreac )

! constants
      REAL              :: ahhp_br, synanti

      CHARACTER(LEN=lsb)    :: progname='*stab crieg cmv*   '
      CHARACTER(LEN=ler)    :: mesg

! ----------
! INITIALIZE
! ----------

      IF (wtflag.NE.0) write(6,*) progname

! check if species is allowed in this routine
      IF (INDEX(rdct(lco+1:lcf),'.(OO.)')==0) THEN
        WRITE(6,'(a)') '--error--, in subroutine stabilized criegee'
        WRITE(6,'(a)') 'this routine was called with'
        WRITE(6,'(a)') 'a species with no criegee:'
        WRITE(6,'(a)') rdct(lco+1:lcf)
        STOP
      ENDIF

! IF RINGS EXIST remove ring-join characters from groups,
      IF (nring.gt.0) THEN
        CALL rjgrm(nring,group,rjg)
      ENDIF

      pchem=' '
      tgroup(:) = group(:)
      coprod(:) = ' '
      p(:)=' '
      tbond(:,:) = bond(:,:)
      internal=.FALSE.
      idci = 0
      ip = 0

! locate criegee group and count number of carbons + '-O-'):
      nc = INDEX(rdct(lco+1:lcf),' ') - 1
      nca = cnum(rdct(lco+1:lcf),nc)+onum(rdct(lco+1:lcf),nc)
      DO i=1,mca
         IF (INDEX(group(i),criegee).NE.0) ip = i
      ENDDO

! remove * from formula if present
      if (index(group(ip),hot_criegee) .ne. 0) then
        pold = hot_criegee
        pnew = criegee
        tempgr = tgroup(ip)
        CALL swap(tempgr,pold,tgroup(ip),pnew)
        CALL rebond(tbond,tgroup,rdct(lco+1:lcf),nring)
        CALL stdchm(rdct(lco+1:lcf))
  !reset
        group = tgroup ! on purpose: we want to keep tgroup
        bond = tbond ! and tbond
      endif


! identify structure of CI
      IF (index(rdct(lco+1:lcf), cold_criegee) .ne. 0) THEN
        idci = idch2oo
      ELSEIF (index(rdct(lco+1:lcf), ext_criegee) .ne. 0) THEN
        idci = idrchoo
      ELSEIF (index(rdct(lco+1:lcf), 'C.(OO.)') .ne. 0) THEN
        idci = idrrcoo
      ELSE
        mesg = 'unidentified criegee structure '
        CALL errexit(progname,mesg,rdct(lco+1:lcf))
      ENDIF

!!  different pathways :
!
      reactant(idH2O_1)  = 'EXTRA '
      reactant(idH2O_2)  = 'EXTRA '
      reactant(idH2O2_1) = 'EXTRA '
      reactant(idH2O2_2) = 'EXTRA '
      reactant(idSO2)    = 'SO2 '
      reactant(idNO)     = 'NO '
      reactant(idNO2)    = 'NO2 '
      reactant(idCO)     = 'CO '
      reactant(idHCl)    = 'HCL '
      reactant(idHNO3)   = 'HNO3 '
      reactant(idO3)     = 'O3 '
      reactant(idself)   = rdct(1:lco)
      reactant(idunimol) = ' '

      idprod(idH2O_1)  = id_carbonyl
      idprod(idH2O_2)  = id_acid
      idprod(idH2O2_1) = id_carbonyl
      idprod(idH2O2_2) = id_acid
      idprod(idSO2)    = id_carbonyl
      idprod(idNO)     = id_carbonyl
      idprod(idNO2)    = id_carbonyl
      idprod(idCO)     = id_carbonyl
      idprod(idHCl)    = id_carbonyl
      idprod(idHNO3)   = id_carbonyl
      idprod(idO3)     = id_carbonyl
      idprod(idself)   = id_carbonyl
      idprod(idunimol) = id_carbonyl

      s_prod(idH2O_1)  = 1.
      s_prod(idH2O_2)  = 1.
      s_prod(idH2O2_1) = 1.
      s_prod(idH2O2_2) = 1.
      s_prod(idSO2)    = 1.
      s_prod(idNO)     = 1.
      s_prod(idNO2)    = 1.
      s_prod(idCO)     = 1.
      s_prod(idHCl)    = 1.
      s_prod(idHNO3)   = 1.
      s_prod(idO3)     = 1.
      s_prod(idself)   = 2.
      s_prod(idunimol) = 1.

      coprod(idH2O_1)  = 'H2O2 '
      coprod(idH2O_2)  = ' '
      coprod(idH2O2_1) = 'H2O2 '
      coprod(idH2O2_2) = ' '
      coprod(idSO2)    = 'SULF '
      coprod(idNO)     = 'NO2 '
      coprod(idNO2)    = 'NO3 '
      coprod(idCO)     = 'CO2 '
      coprod(idHCl)    = 'CLOH '
      coprod(idHNO3)   = 'HNO4 '
      coprod(idO3)     = 'O2 '
      coprod(idself)   = 'O2 '
      coprod(idunimol) = 'HO '

      s_coprod(idH2O_1)  = 1.0
      s_coprod(idH2O_2)  = 0.0
      s_coprod(idH2O2_1) = 1.0
      s_coprod(idH2O2_2) = 0.0
      s_coprod(idSO2)    = 1.0
      s_coprod(idNO)     = 1.0
      s_coprod(idNO2)    = 1.0
      s_coprod(idCO)     = 1.0
      s_coprod(idHCl)    = 1.0
      s_coprod(idHNO3)   = 1.0
      s_coprod(idO3)     = 2.0
      s_coprod(idself)   = 1.0
      s_coprod(idunimol) = 1.0
! assume 0.375/0.625 branching ratio for two possible reactions with water
! RCHOO + H2O = RCHO + H2O2 : 0.375
! RCHOO + H2O = RCO(OH) + H2O : 0.625
! only possible for external criegee and ch2oo
! ahhp_br = alphahydroxyhydroperoxide branching ratio
      ahhp_br = 0.375
      rate(idch2oo, idH2O_1)  = 4.0e-16*ahhp_br
      rate(idch2oo, idH2O_2)  = 4.0e-16*(1-ahhp_br)
      rate(idch2oo, idH2O2_1) = 5.5e-12*ahhp_br
      rate(idch2oo, idH2O2_2) = 5.5e-12*(1-ahhp_br)
      rate(idch2oo, idSO2)    = 3.7e-11
      rate(idch2oo, idNO)     = 6.0e-14
      rate(idch2oo, idNO2)    = 3.0e-12
      rate(idch2oo, idCO)     = 1.03e-21
      rate(idch2oo, idHCl)    = 4.6e-11
      rate(idch2oo, idHNO3)   = 5.4e-10
      rate(idch2oo, idO3)     = 4.0e-13
      rate(idch2oo, idself)   = 7.4e-11
      rate(idch2oo, idunimol) = 0.0

! syn-anti conformation
! assume 50/50
      synanti = 0.5
! assume 0.375/0.625 branching ratio for two possible reactions with water
! RCHOO + H2O = RCHO + H2O2 : 0.375
! RCHOO + H2O = RCO(OH) + H2O : 0.625
! only possible for external criegee and ch2oo
      rate(idrchoo, idH2O_1)  = (synanti*1.40e-15+(1-synanti)*2.27e-14)
     &                         * ahhp_br
      rate(idrchoo, idH2O_2)  = (synanti*1.40e-15+(1-synanti)*2.27e-14)
     &                         * (1-ahhp_br)
      rate(idrchoo, idH2O2_1) = (synanti*2.56e-14+(1-synanti)*1.60e-11)
     &                         * ahhp_br
      rate(idrchoo, idH2O2_2) = (synanti*2.56e-14+(1-synanti)*1.60e-11)
     &                         * (1-ahhp_br)
      rate(idrchoo, idSO2)    = synanti*2.65e-11 + (1-synanti)*1.44e-10
      rate(idrchoo, idNO)     = synanti*6.0e-14 + (1-synanti)*6.0e-14
      rate(idrchoo, idNO2)    = synanti*2.0e-12 + (1-synanti)*2.0e-12
      rate(idrchoo, idCO)     = synanti*3.5e-21 + (1-synanti)*4.03e-20
      rate(idrchoo, idHCl)    = synanti*4.6e-11 + (1-synanti)*4.6e-11
      rate(idrchoo, idHNO3)   = synanti*5.4e-10 + (1-synanti)*5.4e-10
      rate(idrchoo, idO3)     = synanti*3.0e-14 + (1-synanti)*3.0e-12
      rate(idrchoo, idself)   = synanti*7.4e-11 + (1-synanti)*7.4e-11
      rate(idrchoo, idunimol) = synanti*2.27e+02  !only possible for syn-rchoo

      rate(idrrcoo, idH2O_1)  = 1.5e-15
      rate(idrrcoo, idH2O_2)  = 0.0
      rate(idrrcoo, idH2O2_1) = 1.3e-13
      rate(idrrcoo, idH2O2_2) = 0.0
      rate(idrrcoo, idSO2)    = 1.32e-10
      rate(idrrcoo, idNO)     = 6.00e-14
      rate(idrrcoo, idNO2)    = 3.00e-12
      rate(idrrcoo, idCO)     = 3.00e-20
      rate(idrrcoo, idHCl)    = 4.6e-11
      rate(idrrcoo, idHNO3)   = 5.4e-10
      rate(idrrcoo, idO3)     = 8.0e-14
      rate(idrrcoo, idself)   = 7.4e-11
      rate(idrrcoo, idunimol) = 2.6e+02

! construct common products
      tgroup = group
      tbond = bond

      p_carbonyl = ' '

      IF (idci == idrchoo) THEN
        pold = ext_criegee
        pnew = aldehyde
      ELSE IF (idci == idrrcoo) THEN
        pold = 'C.(OO.)'
        pnew = carbonyl
      ENDIF

      IF(idci .ne. idch2oo) THEN
        tempgr = tgroup(ip)
        CALL swap(tempgr,pold,tgroup(ip),pnew)
        CALL rebond(tbond,tgroup,p_carbonyl,nring)
        CALL stdchm(p_carbonyl)
      ELSE
        p_carbonyl = 'CH2O '
      ENDIF

!reset
      tgroup = group
      tbond = bond
      p_acid = ' '

      IF (idci == idrchoo) THEN
        pold = ext_criegee
        pnew = carboxylic_acid
        tempgr = tgroup(ip)
        CALL swap(tempgr,pold,tgroup(ip),pnew)
        CALL rebond(tbond,tgroup,p_acid,nring)
        CALL stdchm(p_acid)
      ENDIF

      IF (idci == idch2oo) THEN
        p_acid = 'CHO(OH) '
      ENDIF

      reac: DO i=1, nbimolreac
        IF (i == idHCl) CYCLE
        IF ((i==idH2O_2 .or. i==idH2O2_2) .and. (idci==idrrcoo)) CYCLE
        CALL rxinit3(a1,a2,a3,a4,r,s,p,ar1,ar2,ar3,
     &             f298,fratio,idreac,nlabel,xlabel,folow,fotroe)

        IF(idprod(i) == id_carbonyl) THEN
          pchem = p_carbonyl
        ELSEIF (idprod(i) == id_acid) THEN
          pchem = p_acid
        ENDIF

        brtio=1
        CALL bratio(pchem,brtio,p(1),
     &             dbrch,dict,namlst,
     &             nhldvoc,holdvoc,nhldrad,holdrad,level,stabl,
     &             nfn,namfn,chemfn)

        a1 = rdct(1:1)
        r(1) = rdct(1:lco)
        r(2)= reactant(i)
        s(1) = s_prod(i)
        s(2) = s_coprod(i)
        p(2) = coprod(i)
        ar1 = rate(idci, i)
        ar2 = 0
        ar3 = 0
        f298 = ar1*(298.**ar2)*exp(-ar3/298.)
        fratio=1.
        IF (i == idH2O_2 .or. i == idH2O_1) THEN
          idreac = 2
          nlabel = 500
        ENDIF
        IF (i == idH2O2_2 .or. i == idH2O2_1) THEN
          idreac = 2
          nlabel = 502 ! new label for reaction with (H2O)2
        ENDIF
        CALL rxwrit3(17,a1,a2,a3,a4,r,s,p,ar1,ar2,ar3,
     &            f298,fratio,idreac,nlabel,xlabel,folow,fotroe)

      ENDDO reac

      IF (wtflag.NE.0) write(6,*) 'done stabilized criegee'

      RETURN
      END

