**********************************************************************
*   MASTER MECHANISM V.3.0 ROUTINE NAME    -     (INTEGER) SRH5      *
*                                                                    *
*            -- OLD COMMENT - NEED UPDATING --                       * 
*            -- OLD COMMENT - NEED UPDATING --                       * 
*            -- OLD COMMENT - NEED UPDATING --                       * 
*                                                                    *
*   PURPOSE         -  Binary tree search - 6-character string       *
*                                                                    *
*   USAGE           -  SRH5(ASEEK,ALIST,NREC)                       *
*                                                                    *
*   ARGUMENTS  ASEEK- string to look for in list                     *
*              ALIST- list of names or strings (e.g. dictionary)     *
*              NREC- number of names in list ALIST                  *
*                                                                    *
*   RETURN VALUE      SRH5 (integer)   - if not found, SRH5 pointer  *
*                                      + if found, SRH5 pointer      *
*                                                                    *
*   ...this function assumes, that array ALIST is sorted by increa-  *
*   sing values.                                                     *
*                                                                    *
*   LOCAL VARIABLES...                                               *
*                                                                    *
*    JHI       highest index value in ALIST                          *
*    JLO       lowest index value in ALIST                           *
*    JOLD      temporary storage of actual pointer in ALIST          *
*    J         actual pointer in ALIST                               *
*                                                                    *
**********************************************************************
      INTEGER FUNCTION srh5(aseek,alist,nlist)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input:
      INTEGER         nlist
      CHARACTER(LEN=lco) aseek, alist(nlist)

* internal:
      INTEGER jhi, jlo, jold, j

* initialize:
      srh5 = 0
      jold = 0
      jlo  = 1
      jhi  = nlist + 1

10    j    = (jhi+jlo)/2
       
      IF(j.EQ.jold) GOTO 40
      jold = j
      IF(aseek.GT.alist(j)) GOTO 20
      IF(aseek.EQ.alist(j)) GOTO 30
      jhi  = j
      GO TO 10
      
20    jlo  = j

      GOTO 10

30    srh5 = j
      RETURN

40    srh5 = -j

* end of SRH5
      RETURN
      END

