* handle single-carbon radicals:
***************************************************************************
      SUBROUTINE single(tchem,prod,coprod)
      IMPLICIT NONE
      INCLUDE 'general.h'
      INCLUDE 'organic.h'
      INCLUDE 'common.h'

* input
      CHARACTER(LEN=lfo) tchem
* output
      CHARACTER(LEN=lfo) prod
      CHARACTER(LEN=lco) coprod(4)

* local
      CHARACTER(LEN=lgr) tgroup, pnew, pold, tempkg
      INTEGER         i

      IF (wtflag.NE.0) WRITE(6,*)'*single* : input : ',TRIM(tchem)

* initialise
      prod = ' '
      tempkg = tchem(1:lgr)
      DO i=1,4
        coprod(i)=' '
      ENDDO

* double bond not allowed:
      IF (tchem(1:2).EQ.'Cd') THEN
         WRITE(6,'(a)') '--error--'
         WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE: single'
         WRITE(6,'(a)') 'illegal single carbon species (Cd):'
         WRITE(6,'(a)') tchem
         WRITE(99,*) 'single',tchem
         STOP
      ENDIF

! Nitro groups -> release of NO2
!      IF ((INDEX(tchem,'(NO2)').NE.0).AND.(INDEX(tchem,'.').NE.0)) THEN
!        pold='(NO2)'
!        pnew='.'
!        CALL swap(tempkg,pold,tgroup,pnew)
!        tchem = tgroup
!        coprod(2)='NO2 '
!      ENDIF

* CH2.. ---> CH2.(OO.)
      IF (tchem(1:5).EQ.'CH2..') THEN
         prod = 'CH2.(OO.)'
         GO TO 900
      ENDIF

      IF (INDEX(tchem,alkyl_peroxy).NE.0)  THEN
         prod = tchem
         GO TO 900
      ENDIF

! Nitro products from aromatics, RV 2016
!      IF (tchem(1:8).EQ.'CO(NO2).') THEN
!        prod='CO '
!        coprod(1)='NO2 '
!      GOTO 900
!      ENDIF
!      IF (tchem(1:11).EQ.'CO(NO2)(O.)') THEN
!        prod='CO2 '
!        coprod(1)='NO2 '
!      GOTO 900
!      ENDIF
!      IF (tchem(1:12).EQ.'CH(OH)(NO2).') THEN
!        prod='CH(OH)(NO2)(OO.) '
!        !coprod(1)='NO2 '
!      GOTO 900
!      ENDIF
!      IF (tchem(1:13).EQ.'CH(NO2)(OOH).') THEN
!        prod='CHO(OH) '
!        coprod(1)='NO2 '
!      GOTO 900
!      ENDIF

* --------------------
* carbonyl: formyl
* --------------------

      IF ((tchem(1:3).EQ.'CHO').OR.(tchem(1:4).EQ.'CHO.')) THEN
          prod = 'CO  '
          coprod(1) = 'HO2  '

* --------------------
* carbonyl: non formyl
* --------------------
         IF (tchem.EQ.'CHO(O.)') THEN
           prod = 'CO2  '
           coprod(1) = 'HO2  '
         ENDIF

      ELSE IF (tchem(1:2).EQ.carbonyl) THEN

* carbonyl-carbene:
         IF ( (INDEX(tchem,'..').NE.0 ) .OR. (tchem.EQ.acyl)) THEN
            prod = 'CO  '

* carbonyl-criegee:
         ELSE IF (INDEX(tchem,criegee).NE.0) THEN
            prod = 'CO  '

* acyl-oxy  and  radical on carbonyl:
         ELSE
            IF (INDEX(tchem,alkoxy).NE.0) THEN
               prod = 'CO2 '
* carbon monoxide:
            ELSE
              prod = 'CO  '
            ENDIF

            IF (INDEX(tchem,hydroxy).NE.0) THEN
               coprod(1) = 'HO   '
            ELSE IF (INDEX(tchem,hydro_peroxide).NE.0) THEN
             coprod(1) = 'HO2  '
            ELSE IF (INDEX(tchem,nitrate).NE.0) THEN
               coprod(1) = 'NO3  '
            ELSE IF (INDEX(tchem,'(OONO2)').NE.0) THEN
               coprod(1) = 'NO2  '
            ELSE IF (INDEX(tchem, '(NO2)') .ne. 0) THEN
              coprod(1) = 'NO2  '
            ELSE IF (INDEX(tchem,'H').NE.0) THEN
               coprod(1) = 'HO2  '
            ELSE
               WRITE(6,'(a)') '--error--2'
               WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE: single'
               WRITE(6,'(a)') 'illegal single carbon species:'
               WRITE(6,'(a)') tchem
               WRITE(99,*) 'single',tchem
               STOP
            ENDIF
         ENDIF

      ELSE IF (INDEX(tchem,alkoxy).NE.0) THEN
        IF (tchem.EQ.'CH2(OOH)(O.)') THEN
          prod= 'CHO(OOH)'
          coprod(1) = 'HO2'
* for CH2(ONO2)(O.) we assume decomposition to CO2 + HO2 + NO2
        ELSE IF (tchem.EQ.'CH2(ONO2)(O.)') THEN
          prod= 'CO2'
          coprod(1) = 'HO2'
          coprod(2) = 'NO2'
        ELSE IF (tchem.EQ.'CH2(OH)(O.)') THEN
          prod= 'CHO(OH)'
          coprod(1) = 'HO2'
        ELSE
           prod = tchem
           GO TO 900
        ENDIF
* --------------------
* alkyl carbon: carbenes = C..
* --------------------

      ELSE IF (INDEX(tchem,'..').NE.0) THEN

         IF (tchem(1:2).EQ.secondary) THEN
            IF (INDEX(tchem,nitrate).NE.0) THEN
               prod = 'CO  '
               coprod(1) = 'HO2  '
               coprod(2) = 'NO2  '
            ELSE IF (INDEX(tchem,hydro_peroxide).NE.0) THEN
               prod = 'CO  '
               coprod(1) = 'HO2  '
               coprod(2) = 'HO   '
            ELSE IF (INDEX(tchem,hydroxy).NE.0) THEN
               prod = 'CO2 '
               coprod(1) = 'HO2  '
               coprod(2) = 'HO   '
            ELSE
               WRITE(6,'(a)') '--error--3'
               WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE: single'
               WRITE(6,'(a)') 'illegal single carbon species:'
               WRITE(6,'(a)') tchem
               WRITE(99,*) 'single',tchem
               STOP
            ENDIF

         ELSE IF (tchem(1:1).EQ.'C') THEN
            IF (INDEX(tchem,nitrate).NE.0) THEN
               pold = nitrate
               pnew = ' '
               CALL swap(tempkg,pold,tgroup,pnew)
               IF (INDEX(tgroup,nitrate).NE.0) THEN
                  prod = 'CO2 '
                  coprod(1) = 'NO2  '
                  coprod(2) = 'NO2  '
               ELSE IF (INDEX(tgroup,hydro_peroxide).NE.0) THEN
                  prod = 'CO2 '
                  coprod(1) = 'NO2  '
                  coprod(2) = 'HO   '
               ELSE IF (INDEX(tgroup,hydroxy).NE.0) THEN
                  prod = 'CO2 '
                  coprod(1) = 'NO2  '
                  coprod(2) = 'HO2  '
               ELSE
                  WRITE(6,'(a)') '--error--4'
                  WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
                  WRITE(6,'(a)') 'illegal single carbon species:'
                  WRITE(6,'(a)') tchem
                  WRITE(99,*) 'single',tchem
                  STOP
               ENDIF

            ELSE IF (INDEX(tchem,hydro_peroxide).NE.0) THEN
               pold = hydro_peroxide
               pnew = ' '
               CALL swap(tempkg,pold,tgroup,pnew)
               IF (INDEX(tgroup,hydro_peroxide).NE.0) THEN
                  prod = 'CO2 '
                  coprod(1) = 'HO   '
                  coprod(2) = 'HO   '
               ELSE IF (INDEX(tgroup,hydroxy).NE.0) THEN
                  prod = 'CO2 '
                  coprod(1) = 'HO   '
                  coprod(2) = 'HO2  '
               ELSE
                  WRITE(6,'(a)') '--error--5'
                  WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
                  WRITE(6,'(a)') 'illegal single carbon species:'
                  WRITE(6,'(a)') tchem
                  WRITE(99,*) 'single',tchem
                  STOP
               ENDIF

            ELSE IF (INDEX(tchem,hydroxy).NE.0) THEN
               pold = hydroxy
               pnew = ' '
               CALL swap(tempkg,pold,tgroup,pnew)
               IF (INDEX(tgroup,hydroxy).NE.0) THEN
                  prod = 'CO2 '
                  coprod(1) = 'HO   '
                  coprod(2) = 'HO   '
               ELSE
                  WRITE(6,'(a)') '--error--6'
                  WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
                  WRITE(6,'(a)') 'illegal single carbon species:'
                  WRITE(6,'(a)') tchem
                  WRITE(99,*) 'single',tchem
                  STOP
               ENDIF

            ELSE
               WRITE(6,'(a)') '--error--7'
               WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
               WRITE(6,'(a)') 'illegal single carbon species:'
               WRITE(6,'(a)') tchem
               WRITE(99,*) 'single',tchem
               STOP
             ENDIF

         ELSE
             WRITE(6,'(a)') '--error--7'
             WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
             WRITE(6,'(a)') 'illegal single carbon species:'
             WRITE(6,'(a)') tchem
             WRITE(99,*) 'single',tchem
             STOP
         ENDIF

* --------------------
* alkyl carbon: criegee diradicals
* --------------------

      ELSE IF (INDEX(tchem,criegee).NE.0) THEN

         IF (tchem(1:2).EQ.secondary) THEN
            IF (INDEX(tchem,hydro_peroxide).NE.0) THEN
               prod = 'CO  '
               coprod(1) = 'HO2  '
               coprod(2) = 'HO   '
            ELSE IF (INDEX(tchem,nitrate).NE.0) THEN
               prod = 'CO  '
               coprod(1) = 'HO2  '
               coprod(2) = 'NO2  '
            ELSE IF (INDEX(tchem,hydroxy).NE.0) THEN
               prod = 'CO2 '
               coprod(1) = 'HO2  '
               coprod(2) = 'HO   '
            ELSE
               WRITE(6,'(a)') '--error--7'
               WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
               WRITE(6,'(a)') 'illegal single carbon species:'
               WRITE(6,'(a)') tchem
               WRITE(99,*) 'single',tchem
               STOP
            ENDIF

         ELSE IF (tchem(1:1).EQ.'C') THEN
            IF (INDEX(tchem,nitrate).NE.0) THEN
               pold = nitrate
               pnew = ' '
               CALL swap(tempkg,pold,tgroup,pnew)
               IF (INDEX(tgroup,nitrate).NE.0) THEN
                  prod = 'CO2 '
                  coprod(1) = 'NO2  '
                  coprod(2) = 'NO2  '
               ELSE IF (INDEX(tgroup,hydro_peroxide).NE.0) THEN
                  prod = 'CO2 '
                  coprod(1) = 'NO2  '
                  coprod(2) = 'HO   '
               ELSE IF (INDEX(tgroup,hydroxy).NE.0) THEN
                  prod = 'CO2 '
                  coprod(1) = 'NO2  '
                  coprod(2) = 'HO2  '
               ELSE
                 WRITE(6,'(a)') '--error--8'
                 WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
                 WRITE(6,'(a)') 'illegal single carbon species:'
                 WRITE(6,'(a)') tchem
                 WRITE(99,*) 'single',tchem
                 STOP
               ENDIF

            ELSE IF (INDEX(tchem,hydro_peroxide).NE.0) THEN
               pold = hydro_peroxide
               pnew = ' '
               CALL swap(tempkg,pold,tgroup,pnew)
                 IF (INDEX(tgroup,hydro_peroxide).NE.0) THEN
                    prod = 'CO2 '
                    coprod(1) = 'HO   '
                    coprod(2) = 'HO   '
                 ELSE IF (INDEX(tgroup,hydroxy).NE.0) THEN
                    prod = 'CO2 '
                    coprod(1) = 'HO   '
                    coprod(2) = 'HO2  '
                 ELSE
                   WRITE(6,'(a)') '--error--9'
                   WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
                   WRITE(6,'(a)') 'illegal single carbon species:'
                   WRITE(6,'(a)') tchem
                   WRITE(99,*) 'single',tchem
                   STOP
                 ENDIF

            ELSE IF (INDEX(tchem,hydroxy).NE.0) THEN
               pold = hydroxy
               pnew = ' '
               CALL swap(tempkg,pold,tgroup,pnew)
               IF (INDEX(tgroup,hydroxy).NE.0) THEN
                  prod = 'CO2 '
                  coprod(1) = 'HO   '
                  coprod(2) = 'HO   '
               ELSE
                 WRITE(6,'(a)') '--error--10'
                 WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
                 WRITE(6,'(a)') 'illegal single carbon species:'
                 WRITE(6,'(a)') tchem
                 WRITE(99,*) 'single',tchem
                 STOP
               ENDIF

            ELSE
               WRITE(6,'(a)') '--error--11'
               WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
               WRITE(6,'(a)') 'illegal single carbon species:'
               WRITE(6,'(a)') tchem
               WRITE(99,*) 'single',tchem
               STOP
            ENDIF

         ELSE
            WRITE(6,'(a)') '--error--12'
            WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
            WRITE(6,'(a)') 'illegal single carbon species:'
            WRITE(6,'(a)') tchem
            WRITE(99,*) 'single',tchem
            STOP
         ENDIF


* -----------------------------
* alkyl carbon: methyl
* ----------------------------

      ELSE IF (tchem(1:3).EQ.methyl) THEN

* methyl --> methylperoxy
         prod = "CH3(OO.)"

* -----------------------------
* alkyl carbon: primary
* ----------------------------

      ELSE IF (tchem(1:3).EQ.primary) THEN

         prod = 'CH2O'
         IF (INDEX(tchem,hydro_peroxide).NE.0) THEN
            coprod(1) = 'HO   '
         ELSE IF (INDEX(tchem,hydroxy) .NE.0) THEN
            coprod(1) = 'HO2  '
         ELSE IF (INDEX(tchem,nitrate).NE.0) THEN
            coprod(1) = 'NO2  '
! JMLT Jun 2020
         ELSE IF (INDEX(tchem,peroxy_nitrate).NE.0) THEN
            coprod(1) = 'NO3  '
         ELSE
            WRITE(6,'(a)') '--error--13'
            WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
            WRITE(6,'(a)') 'illegal single carbon species:'
            WRITE(6,'(a)') tchem
            WRITE(99,*) 'single',tchem
            STOP
         ENDIF

* -----------------------------
* alkyl carbon: secondary
* ----------------------------

      ELSE IF (tchem(1:2).EQ.secondary) THEN

         pold = '.'
         pnew = ' '
         CALL swap(tempkg,pold,tgroup,pnew)
           tempkg = tgroup
           pold = secondary
         pnew = aldehyde
         CALL swap(tempkg,pold,tgroup,pnew)
         IF (INDEX(tchem,hydro_peroxide).NE.0) THEN
            coprod(2) = 'HO   '
            pold = hydro_peroxide
            pnew = ' '
            CALL swap(tgroup,pold,prod(1:lgr),pnew)
         ELSE IF (INDEX(tchem,hydroxy).NE.0) THEN
            coprod(2) = 'HO2  '
            pold = hydroxy
            pnew = ' '
            CALL swap(tgroup,pold,prod(1:lgr),pnew)
         ELSE IF (INDEX(tchem,nitrate).NE.0) THEN
            coprod(2) = 'NO2  '
            pold = nitrate
            pnew = ' '
            CALL swap(tgroup,pold,prod(1:lgr),pnew)
* JMLT June 2020
         ELSE IF (INDEX(tchem,peroxy_nitrate).NE.0) THEN
            coprod(2) = 'NO3  '
            pold = peroxy_nitrate
            pnew = ' '
            CALL swap(tgroup,pold,prod(1:lgr),pnew)
         ELSE
            WRITE(6,'(a)') '--error--14'
            WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
            WRITE(6,'(a)') 'illegal single carbon species:'
            WRITE(6,'(a)') tchem
            WRITE(99,*) 'single',tchem
            STOP
         ENDIF

* -----------------------------
* alkyl carbon: C
* ----------------------------

      ELSE IF (tchem(1:1).EQ.'C') THEN

         pold = '.'
         pnew = ' '
         CALL swap(tempkg,pold,tgroup,pnew)
           tempkg = tgroup
           pold = 'C'
         pnew = carbonyl
         CALL swap(tempkg,pold,tgroup,pnew)
         IF (INDEX(tchem,hydro_peroxide).NE.0) THEN
            coprod(2) = 'HO   '
            pold = hydro_peroxide
            pnew = ' '
            CALL swap(tgroup,pold,prod(1:lgr),pnew)
         ELSE IF (INDEX(tchem,hydroxy).NE.0) THEN
            coprod(2) = 'HO2  '
            pold = hydroxy
            pnew = ' '
            CALL swap(tgroup,pold,prod(1:lgr),pnew)
         ELSE IF (INDEX(tchem,nitrate).NE.0) THEN
            coprod(2) = 'NO2  '
            pold = nitrate
            pnew = ' '
            CALL swap(tgroup,pold,prod(1:lgr),pnew)
* JMLT June 2020
         ELSE IF (INDEX(tchem,peroxy_nitrate).NE.0) THEN
            coprod(2) = 'NO3  '
            pold = peroxy_nitrate
            pnew = ' '
            CALL swap(tgroup,pold,prod(1:lgr),pnew)
         ELSE
            WRITE(6,'(a)') '--error--15'
            WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
            WRITE(6,'(a)') 'illegal single carbon species:'
            WRITE(6,'(a)') tchem
            WRITE(99,*) 'single',tchem
            STOP
         ENDIF

* -----------------------------
* error
* ----------------------------

      ELSE

         WRITE(6,'(a)') '--error--16'
         WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:single'
         WRITE(6,'(a)') 'illegal single carbon species:'
         WRITE(6,'(a)') tchem
         WRITE(99,*) 'single',tchem
         STOP

      ENDIF

900   CONTINUE

      IF(wtflag.NE.0)THEN
        WRITE(6,*)"*single* : outpt : ",TRIM(prod)," : ",coprod(1:2)
      ENDIF

      RETURN
      END
