!--------------------------------------------------------------------------!
! MASTER MECHANISM - ROUTINE NAME : rjsrm                                  !
!                                                                          !
! PURPOSE: Strip ring-joining numerical characters from chem strings.      !
!          Subroutine rjsadd puts them back.                               !
! CREATED: June/July 2005, Julia Lee-TAYLOR, NCAR                          !
!                                                                          !
! IN/OUT:                                                                  !
! - chem        : chemical name                                            !
!                                                                          !
! OUTPUT:                                                                  !
! - rjs(j,2)    : character numbers of ring-joining pairs for each ring    !
!                                                                          !
!--------------------------------------------------------------------------!
      SUBROUTINE rjsrm(nring,chem,rjs)
      IMPLICIT NONE
      INCLUDE 'general.h'

! in/out:
      INTEGER   nring
      CHARACTER(LEN=lfo) chem
! output:
      INTEGER    rjs(mri,2)
! internal:
      INTEGER    n,i,j,k,ptr

!--------------------------------------------------------------------------!
      !print*,'*rjsrm*'

      DO n=1,nring
        DO j=1,2
          rjs(n,j)=0
          ptr = 1
          DO i=1,lfo
            IF(chem(i:i).EQ.' ') GOTO 50 ! exit
            IF(chem(i:i).EQ.'C'.OR.chem(i:i).EQ.'c'
     &         .OR.chem(i:i).EQ.'-')THEN
              ptr=i+1 
              IF(chem(ptr:ptr).EQ.'d') ptr=ptr+1
              IF(chem(ptr-1:ptr).EQ.'-O') ptr=ptr+1
              IF(chem(ptr:ptr).EQ.digit(n)) THEN ! found ring-joining character
                rjs(n,j)=ptr
                DO k=ptr,lfo-1
                  chem(k:k) = chem(k+1:k+1)
                ENDDO
                GO TO 50 ! exit
              ENDIF
            ENDIF
          ENDDO
50        CONTINUE
        ENDDO
      ENDDO

      !print*,chem

      END
