! MASTER MECHANISM - ROUTINE NAME : rjsadd                                 !
!                                                                          !
! PURPOSE: Add ring-joining numerical characters to group strings          !
!          at nodes given by rj.                                           !
! CREATED: June/July 2005, Julia Lee-TAYLOR, NCAR !
!                                                                          !
! INPUT:                                                                   !
! - rjs(j,2)    : character numbers of ring-joining pairs for each ring    !
!                                                                          !
! IN/OUT:                                                                  !
! - chem        : chemical name                                            !
!                                                                          !
!--------------------------------------------------------------------------!
      SUBROUTINE rjsadd(nring,chem,rjs)
      IMPLICIT NONE
      INCLUDE 'general.h'

! input:
      INTEGER    rjs(mri,2),nring
! in/out:
      CHARACTER(LEN=lfo) chem
! internal:
      INTEGER    n,i,ii,j,k

!--------------------------------------------------------------------------!
      !print*,'*rjsadd*'
! loop in reverse order => chars in numerical order if >1 exist at any node
      DO n=nring,1,-1
        DO 10 j=2,1,-1
          i = rjs(n,j)
	  IF (i.EQ.0) GOTO 10
          DO k=lfo-1,i,-1
             chem(k+1:k+1) = chem(k:k)
          ENDDO
          chem(i:i)=digit(n)
10      CONTINUE
      ENDDO

      !print*,chem

      END
!--------------------------------------------------------------------------!
