************************************************************************
* MASTER MECHANISM - ROUTINE NAME : rddict                             *
*                                                                      *
* PURPOSE: - read the list of known 'species' for which the stucture   *
*            can not be handled by the generator (e.g. cyclic molecule *
*            like furan made by some photolytic reaction)              *
*                                                                      *
* INPUT:   none                                                        *
*                                                                      *
* OUTPUT:                                                              *
* - nspsp       : total number of "special" species (e.g. furane)      *
* - lospsp(i)   : logical table to check if a given special species    *
*                 has been used.                                       *
* - dictsp(i)   : list of the "known" special species                  *
************************************************************************
      SUBROUTINE rdspsp(nspsp,lospsp,dictsp)
      IMPLICIT NONE
      INCLUDE 'general.h'

* output
      INTEGER         nspsp
      LOGICAL         lospsp(mfn)
      CHARACTER(LEN=ldi) dictsp(mfn)

*local
      CHARACTER(LEN=ldi) line
      CHARACTER(LEN=50) filename
      INTEGER         i,j
      INTEGER         cnum,nc,nca


* initialize
      filename = 'mcm.3.3.1_mxyl_furan_dic.dat'

      nspsp = 0
      DO i=1,mfn
        dictsp(i)=' '
        lospsp(i)=.false.
      ENDDO

*  read the list of the special species.

      OPEN (10,file='../DATA/'//filename,status='OLD')
!     &         form='FORMATTED')

      DO 10 i=1,10000
        READ(10,'(a)',err=999, end=222) line
        IF (line(1:1).EQ.'*') GO TO 10
        IF (line(1:3).EQ.'END') GO TO 15

      nspsp = nspsp + 1
      IF (nspsp.gt.mfn) THEN
        WRITE(6,*) '--error-- in rdspsp subroutine. The number'
        WRITE(6,*) '          of species in the "special" dictionary'
        WRITE(6,*) '          exceed maximum size allowed. Change '
        WRITE(6,*) '          the "mfn" parameter in general.h'
        STOP
      ENDIF
      dictsp(nspsp) = line(1:ldi)
10    CONTINUE

15    CLOSE(10)
      RETURN

222   WRITE (6,*) '--error222--, while reading '//filename
      WRITE (6,*) '              keyword end not found'
      STOP

999   WRITE (6,*) '--error999--, while reading '//filename
      STOP

      END
