************************************************************************
* MASTER MECHANISM - ROUTINE NAME : rdfixam                            *
*                                                                      *
* PURPOSE: some species have a name (6 characters) that is not set
*          by the generator but is prescribed (for example to make
*          the link with the name of species that nmay be set by
*          an emission program ...). This routine read   
*      
*
*     Subroutine to read file where some names are fixed
*
* INPUT:   none                                                        *
*                                                                      *
* OUTPUT:                                                              *
* - nfn         : total nb. of species having a fixed name   
* - namfn(i)    : table of the fixed name (6 character)       
* - chemfn(i)   : formula corresponding the ith species having a    
*                 fixed name                               
************************************************************************
      SUBROUTINE rdfixnam(nfn,namfn,chemfn)
      IMPLICIT NONE
      INCLUDE 'general.h'

* output
      INTEGER         nfn
      CHARACTER(LEN=lco) namfn(mfn)
      CHARACTER(LEN=lfo) chemfn(mfn)

*local
      INTEGER i,n
      CHARACTER(LEN=ldi) line

* initialize
      nfn=0
      DO i=1,mfn
        namfn(i) = ' '
        chemfn(i) = ' '
      ENDDO

* open the file
      OPEN (10,file='../DATA/fixedname.dat',status='OLD')

*  read 
      DO 10 i=1,10000
        READ(10,'(a)', end=222, err=333) line
        IF (line(1:1).EQ.'*') GO TO 10
        IF (line(1:3).EQ.'END') GO TO 15

* check if the line is correctly formatted
        n= index(line,'|')
        IF (n.eq.0) THEN
          WRITE(6,'(a)') '--error--, while reading fixedname.dat'
          WRITE(6,'(a)') '           | not found at line'
          WRITE(6,'(a)') line
          STOP
        ENDIF

        nfn = nfn + 1
        IF (nfn.ge.mfn) THEN
          WRITE(6,'(a)') '--error--, in rdfixnam'
          WRITE(6,'(a)') 'number of species in fixedname.dat'
          WRITE(6,'(a)') 'is greater than defined in general.f'
          STOP
        ENDIF  
        namfn(nfn)=line(1:6)
        chemfn(nfn)=line(10:INDEX(line(10:ldi)," ")-1)
        chemfn(nfn)=line(10:ldi)

        CALL stdchm(chemfn(nfn))
10    CONTINUE

15    CONTINUE
      CLOSE(10)

      RETURN

222   WRITE(6,*) '--error222--, while reading fixedname.dat'
      WRITE(6,*) '              keyword end not found'
      STOP

333   WRITE(6,*) '--error333--, while reading fixedname.dat'
      STOP

      END
