************************************************************************
* MASTER MECHANISM - ROUTINE NAME : rdbenson                           *
*                                                                      *
* PURPOSE: read heat of formation of the benson group                  *
*                                                                      *
* INPUT:   none                                                        *
*                                                                      *
* OUTPUT:                                                              *
* - nbson        : total number of benson group                        *
* - bsongrp(i)   : table of benson group                               *
* - bsonval(i)   : heat of formation corresponding to group i          *
************************************************************************
      SUBROUTINE rdbenson(nbson,bsongrp,bsonval)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input : none

* output 
      INTEGER         nbson
      REAL            bsonval(mbg)
      CHARACTER(LEN=lgb) bsongrp(mbg)

* internal
      INTEGER i
      CHARACTER(LEN=llin) line

* initialize
      nbson=0
      DO i=1,mbg
        bsongrp(i)=' ' 
        bsonval(i)=0.
      ENDDO

* open the file
      OPEN (UNIT=10,FILE='../DATA/benson.dat',STATUS='OLD')
!    &      ,FORM='FORMATTED')

* read benson group
      DO 10 i=1,10000
        READ (10,'(a)', end=222) line
        IF (line(1:3).EQ.'END') GOTO 20
        IF (line(1:1).EQ.'*') GOTO 10

        IF (line(25:25).NE.' ') THEN
          WRITE(6,*)'--error--, while reading bensongrp.dat'
          WRITE(6,*)'benson group is longer than 24 characters'
          WRITE(6,*) line
          STOP 
        ENDIF
        nbson=nbson+1
        IF (nbson.ge.mbg) THEN
          WRITE (6,'(a)') '--error--, while reading bensongrp.dat'
          WRITE (6,'(a)') 'number of benson grp is greater than mbg'
          STOP
        ENDIF
        READ(line,'(a24,1x,f10.3)',err=333) 
     &              bsongrp(nbson),bsonval(nbson)
10    CONTINUE

20    CONTINUE
      CLOSE (10)

      RETURN

222   WRITE(6,*) '--error222--, while reading bensongrp.dat'
      WRITE(6,*) 'keyword END not found'
      STOP
333   WRITE(6,*) '--error333--, while reading bensongrp.dat at line'
      WRITE(6,*) line, nbson
      STOP

      END
