************************************************************************
* MASTER MECHANISM - ROUTINE NAME : raddno3                            *
*                                                                      *
*                                                                      *
* PURPOSE :                                                            *
*   Find rate constants for NO2 addition on VOC double bonds based on  *
*   Kerdouci et al., 2010.                                             *
*                                                                      *
* INPUT:                                                               *
* - tgroup(i)     : groups at position (carbon) i                      *
* - tbond(i,j)    : carbon-carbon bond matrix of chem                  *
* - i1,i2         : carbon number of group bearing the Cd              *
*                                                                      *
* OUTPUT                                                               *
* - arrhc(3)     : arrhenius coefficient for H abstraction             *
*                                                                      *
*************************************************************************
      SUBROUTINE raddno3(tbond,tgroup,i1,i2,arrhc)
      IMPLICIT NONE
      INCLUDE 'general.h'
      INCLUDE 'organic.h'
      INCLUDE 'common.h'

* input
      INTEGER         tbond(mca,mca)
      CHARACTER(LEN=lgr) tgroup(mca)
      INTEGER         i1,i2
      INTEGER         nring

* output
      REAL            arrhc(3)

* internal:
      INTEGER         i,j,k,l
      REAL            mult
      INTEGER         nether,nca,ngr,begrg,endrg,ntr,dbfg
      INTEGER         ring(mca)     ! rg index for nodes, current ring (0=no, 1=yes)
      INTEGER         rjg(mri,2)    ! ring-join group pairs
      INTEGER         rngflg        ! 0 = 'no ring', 1 = 'yes ring'
      INTEGER         lring(2)         ! length of the ring bearing the double bond
      INTEGER         trlen(mco)
      INTEGER         track(mco,mca)
      CHARACTER(LEN=lfo) tchem

      IF (wtflag.NE.0) WRITE(*,*)
     & "*raddno3*------------------------- i1 = ",i1,' ',tgroup(i1)
* -----------
* initialize
* -----------
      DO i=1,3
        arrhc(i)=0.
      ENDDO
      nring=0
      nca=0
      ngr=0
      DO i=1,mca
        IF (tgroup(i)(1:1).EQ.'C') nca=nca+1
        IF (tgroup(i)(1:1).NE.' ') ngr=ngr+1
      ENDDO
      lring(1)=0
      lring(2)=0

* check ig value is ok
      IF (tbond(i1,i2).NE.2) THEN
         WRITE(6,*) '--error--, in raddno3'
         WRITE(6,*) ' => called with a simple bond'
         STOP
      ENDIF

! find the number of rings
      CALL rebond(tbond,tgroup,tchem,nring)
! find if the double is in a ring
      CALL findring(i1,i2,ngr,tbond,rngflg,ring)
! find the legnth of the rings
      IF (rngflg.EQ.1) THEN
        IF (nring.GT.0) THEN
          k=1
          CALL gettrack(tbond,i1,ngr,ntr,track,trlen)
          DO j=1,ntr
            dbfg=0                                                 ! flag to check if the double bond is in the cycle
            DO l=2,trlen(j)
              IF (tbond(track(j,l-1),track(j,l)).EQ.2) dbfg=1
            ENDDO
            IF (tbond(i1,track(j,trlen(j))).EQ.2) dbfg=1

            IF ((trlen(j).GT.2).AND.
     &          (tbond(i1,track(j,trlen(j))).GT.0)) THEN
              IF (dbfg.EQ.1) THEN
                lring(k)=trlen(j)
                DO l=1,trlen(j)
                  IF (tgroup(track(j,l))(1:3).EQ.'-O-') THEN       ! do not count -O- in the number of carbon in a cycle
                    lring(k)=lring(k)-1
                  ENDIF
                ENDDO
!                WRITE(6,*) 'THERE IS A RING OF SIZE',lring(k)
                k=k+1
                IF (k.GT.nring) GOTO 123
              ENDIF
            ENDIF
          ENDDO
        ENDIF
      ENDIF

123   CONTINUE

* ------------------
* FIND K(0) VALUE
* ------------------

* Values are from Kerdouci et al., 2014
      IF (((tgroup(i1)(1:4).EQ.'CdH2').AND.(tgroup(i2)(1:4).EQ.'CdH '))
     &.OR.((tgroup(i1)(1:4).EQ.'CdH ').AND.(tgroup(i2)(1:4).EQ.'CdH2'))
     &.OR.((tgroup(i1)(1:4).EQ.'CdH2').AND.(tgroup(i2)(1:4).EQ.'CdH('))
     &.OR.((tgroup(i1)(1:4).EQ.'CdH(').AND.(tgroup(i2)(1:4).EQ.'CdH2')))
     &   THEN
        arrhc(1) = 1.14E-14
        arrhc(2) = 0
        arrhc(3) = 0.
! effect of the lenght of the carbon chain
        IF (nca.GT.3) THEN
          mult =  -0.64 + 3.14 *(1-exp(-0.17*(nca)))
          arrhc(1)=arrhc(1)*mult
        ENDIF
      ELSE IF
     & (((tgroup(i1)(1:4).EQ.'CdH2').AND.(tgroup(i2)(1:3).EQ.'Cd '))
     &.OR.((tgroup(i1)(1:3).EQ.'Cd ').AND.(tgroup(i2)(1:4).EQ.'CdH2'))
     &.OR.((tgroup(i1)(1:4).EQ.'CdH ').AND.(tgroup(i2)(1:4).EQ.'CdH '))
     &.OR.((tgroup(i1)(1:4).EQ.'CdH ').AND.(tgroup(i2)(1:4).EQ.'CdH('))
     &.OR.((tgroup(i1)(1:4).EQ.'CdH(').AND.(tgroup(i2)(1:4).EQ.'CdH '))
     &.OR.((tgroup(i1)(1:4).EQ.'CdH2').AND.(tgroup(i2)(1:3).EQ.'Cd('))
     &.OR.((tgroup(i1)(1:3).EQ.'Cd(').AND.(tgroup(i2)(1:4).EQ.'CdH2'))
     &.OR.((tgroup(i1)(1:4).EQ.'CdH(').AND.(tgroup(i2)(1:4).EQ.'CdH(')))
     &  THEN
        arrhc(1) = 3.40E-13
        arrhc(2) = 0
        arrhc(3) = 0.
      ELSE IF
     & (((tgroup(i1)(1:4).EQ.'CdH ').AND.(tgroup(i2)(1:3).EQ.'Cd '))
     &.OR.((tgroup(i1)(1:4).EQ.'CdH ').AND.(tgroup(i2)(1:3).EQ.'Cd('))
     &.OR.((tgroup(i1)(1:4).EQ.'CdH(').AND.(tgroup(i2)(1:3).EQ.'Cd('))
     &.OR.((tgroup(i1)(1:4).EQ.'CdH(').AND.(tgroup(i2)(1:3).EQ.'Cd('))
     &.OR.((tgroup(i1)(1:4).EQ.'CdH(').AND.(tgroup(i2)(1:3).EQ.'Cd '))
     &.OR.((tgroup(i1)(1:3).EQ.'Cd ').AND.(tgroup(i2)(1:4).EQ.'CdH '))
     &.OR.((tgroup(i1)(1:3).EQ.'Cd ').AND.(tgroup(i2)(1:4).EQ.'CdH('))
     &.OR.((tgroup(i1)(1:3).EQ.'Cd(').AND.(tgroup(i2)(1:4).EQ.'CdH '))
     &.OR.((tgroup(i1)(1:3).EQ.'Cd(').AND.(tgroup(i2)(1:4).EQ.'CdH(')))
     &  THEN
        arrhc(1) = 8.35E-12
        arrhc(2) = 0
        arrhc(3) = 0.
      ELSE IF
     & (((tgroup(i1)(1:3).EQ.'Cd ').AND.(tgroup(i2)(1:3).EQ.'Cd '))
     &.OR.((tgroup(i1)(1:3).EQ.'Cd(').AND.(tgroup(i2)(1:3).EQ.'Cd('))
     &.OR.((tgroup(i1)(1:3).EQ.'Cd ').AND.(tgroup(i2)(1:3).EQ.'Cd('))
     &.OR.((tgroup(i1)(1:3).EQ.'Cd(').AND.(tgroup(i2)(1:3).EQ.'Cd ')))
     &  THEN
        arrhc(1) = 4.50E-11
        arrhc(2) = 0
        arrhc(3) = 0.
      ELSE IF ((tgroup(i1)(1:4).EQ.'CdH2').AND.
     &    (tgroup(i2)(1:4).EQ.'CdH2')) THEN
        arrhc(1) = 4.88E-18
        arrhc(2) = 2.
        arrhc(3) = 2282.
      ELSE
        WRITE(6,'(a)') '--error--'
        WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE : raddno3'
        WRITE(6,'(a)') 'group not allowed to react with NO3'
        WRITE(6,'(a)') tgroup(i1),tgroup(i2)
        STOP
      ENDIF
30    CONTINUE

! effect of the lenght of the carbon chain
      IF
     & (((tgroup(i1)(1:4).EQ.'CdH2').AND.(tgroup(i2)(1:3).EQ.'Cd '))
     &.OR.((tgroup(i1)(1:3).EQ.'Cd ').AND.(tgroup(i2)(1:4).EQ.'CdH2')))
     &  THEN
        mult =  -1.16 + 3.06 *(1-exp(-0.32*nca))
        arrhc(1)=arrhc(1)*mult
      ENDIF

! effect of the lenght of the cycle chain
      IF (rngflg.EQ.1) THEN
        mult = 1
        DO i=1,nring
          IF (lring(i).EQ.3) mult=mult*0.033
          IF (lring(i).EQ.4) mult=mult*0.73
          IF (lring(i).EQ.5) mult=mult*2.32
          IF (lring(i).EQ.6) mult=mult*0.93
          IF (lring(i).EQ.7) mult=mult*1.34
        ENDDO
        arrhc(1)=arrhc(1)*mult
      ENDIF

* ---------------------------------------
* FIND MULTIPLIERS BASED ON SUBSTITUENTS
* ---------------------------------------
* conjugated double bonds factors


* on alpha carbons:
      nether = 0
      DO 10 i=1,ngr
        mult = 1.
        IF ((tbond(i1,i).EQ.1).OR.(tbond(i2,i).EQ.1).OR.
     &      (tbond(i1,i).EQ.3).OR.(tbond(i2,i).EQ.3)) THEN
* simple alkyl:
          IF (tgroup(i)(1:3).EQ.methyl) THEN
            mult =  1.
            arrhc(1)=arrhc(1)*mult
          ENDIF
          IF(tgroup(i)(1:4) .EQ. 'CH2 ') THEN
            DO j=1,ngr
              IF ((tbond(i,j).NE.0).AND.(j.NE.i1).AND.(j.NE.i2)) THEN
              IF (tbond(i,j).EQ.3) THEN
                DO k=1,ngr
                  IF ((tbond(j,k).EQ.3).AND.(tgroup(k)(1:2).EQ.'CO'))
     &              THEN
                    mult=0.1
                    GOTO 31
                  ENDIF
                ENDDO
              ELSE IF ((tbond(i,j).EQ.1).AND.(tgroup(j).EQ.'CH2(OH)'))
     &          THEN
                mult = 0.68
              ELSE IF ((tbond(i,j).EQ.1).AND.(tgroup(j)(1:2).EQ.'CO'))
     &          THEN
                mult = 0.19
              ELSE
                mult = 1.15
              ENDIF
              ENDIF
            ENDDO
31          CONTINUE
            arrhc(1)=arrhc(1)*mult
          ENDIF
          IF(tgroup(i)(1:7) .EQ. 'CH2(OH)') THEN
            mult =  0.63
            arrhc(1)=arrhc(1)*mult
          ENDIF

          IF(tgroup(i)(1:3) .EQ. 'CH ' ) THEN
            mult =  0.97
            arrhc(1)=arrhc(1)*mult
          ENDIF
          IF(tgroup(i)(1:6) .EQ. 'CH(OH)' ) THEN
            mult =  0.89
            arrhc(1)=arrhc(1)*mult
          ENDIF

          IF(tgroup(i)(1:2) .EQ. 'C('  ) THEN
            IF (tgroup(i)(1:5) .EQ. 'C(OH)'  ) THEN
              mult =  0.91
              arrhc(1)=arrhc(1)*mult
            ELSE
              DO j=1,ngr
                IF ((tbond(i,j).EQ.3).AND.(j.ne.i1).AND.(j.NE.i2)) THEN
                  mult =  0.3
                ELSE
                  mult =  0.6
                ENDIF
              ENDDO
              arrhc(1)=arrhc(1)*mult
            ENDIF
          ENDIF
          IF(tgroup(i)(1:2) .EQ. 'C '  ) THEN
            DO j=1,mca
              IF ((tbond(i,j).EQ.3).AND.(j.ne.i1).AND.(j.NE.i2)) THEN
                mult =  0.3
              ELSE
                mult =  0.6
              ENDIF
            ENDDO
            arrhc(1)=arrhc(1)*mult
          ENDIF

* overwrite for carbonyls, esters and aldehydes values
          IF (tgroup(i)(1:2).EQ.carbonyl) THEN
            DO j=1,ngr
              IF ((tbond(i,j).EQ.3).AND.(j.ne.i1).AND.(j.NE.i2)) THEN
                mult =  0.008
              ELSE IF ((tbond(i,j).EQ.1).AND.(j.ne.i1).AND.(j.NE.i2))
     &        THEN
                mult =  0.02
              ENDIF
            ENDDO
            arrhc(1)=arrhc(1)*mult
          ENDIF
          IF (tgroup(i)(1:3).EQ.aldehyde) THEN
            mult =  0.002
            arrhc(1)=arrhc(1)*mult
          ENDIF

* Ethers and esters
* For acetal, consider only one -O- influence
          IF (INDEX(tgroup(i),ether).NE.0) THEN
            DO j=1,ngr
              IF ((tbond(i,j).EQ.3).AND.(j.ne.i1).AND.(j.NE.i2)) THEN
!! ether in alpha of ig
         	IF (tgroup(j)(1:3).EQ.methyl) THEN
         	  mult =  61.
         	  arrhc(1)=arrhc(1)*mult
         	ENDIF
         	IF(tgroup(j)(1:4) .EQ. 'CH2 ') THEN
         	  mult =  127.
         	  arrhc(1)=arrhc(1)*mult
         	ENDIF
         	IF(tgroup(j)(1:4) .EQ. 'CH2(') THEN
         	  mult =  127.
         	  arrhc(1)=arrhc(1)*mult
         	ENDIF
         	IF(tgroup(j)(1:3) .EQ. 'CH ' ) THEN
         	  mult =  150.
         	  arrhc(1)=arrhc(1)*mult
         	ENDIF
         	IF(tgroup(j)(1:3) .EQ. 'CH(' ) THEN
         	  mult =  150.
         	  arrhc(1)=arrhc(1)*mult
         	ENDIF
         	IF(tgroup(j)(1:2) .EQ. 'C('  ) THEN
         	  mult =  294.
         	  arrhc(1)=arrhc(1)*mult
         	ENDIF
         	IF(tgroup(j)(1:2) .EQ. 'C '  ) THEN
         	  mult =  294.
         	  arrhc(1)=arrhc(1)*mult
         	ENDIF
                IF (tgroup(j)(1:2).EQ.carbonyl) THEN
                  mult = 0.46
                  arrhc(1)=arrhc(1)*mult
                ENDIF
              ENDIF
            ENDDO
          ENDIF

* conjugated double bonds factors
          IF (tgroup(i)(1:4).EQ.'CdH ') THEN
            mult=1
            DO j=1,ngr
              IF ((tbond(i,j).EQ.2).AND.(j.ne.i1).AND.(j.NE.i2)) THEN
                IF (tgroup(j)(1:4).EQ.'CdH2') THEN
                   mult =  3.6
                ELSE IF (tgroup(j)(1:4).EQ.'CdH ') THEN
                   mult =  18      ! mean value between 12 for cis and 24 for trans
                ENDIF
              ENDIF
            ENDDO
            arrhc(1)=arrhc(1)*mult
          ENDIF

          IF (tgroup(i)(1:3).EQ.'Cd ') THEN
            mult=1
            DO j=1,ngr
              IF ((tbond(i,j).EQ.2).AND.(j.ne.i1).AND.(j.NE.i2)) THEN
                IF (tgroup(j)(1:4).EQ.'CdH2') THEN
                   mult =  2.1
                ELSE IF (tgroup(j)(1:4).EQ.'CdH ') THEN
                   mult =  5.4
                ENDIF
              ENDIF
            ENDDO
            arrhc(1)=arrhc(1)*mult
          ENDIF

        ENDIF
10    CONTINUE

* exit point
20    CONTINUE
* end of raddno3
      RETURN
      END

