**********************************************************************
*   MASTER MECHANISM V.3.0 ROUTINE NAME        -       RABSOH        *
*                                                                    *
*            -- OLD COMMENT - NEED UPDATING --                       * 
*            -- OLD COMMENT - NEED UPDATING --                       * 
*            -- OLD COMMENT - NEED UPDATING --                       * 
*                                                                    *
*   PURPOSE         -  Find rate constants for H-atom abstraction    *
*                      from hydrocarbons by HO based on analysis by  *
*                      Atkinson,R., Int. J. Chem. Kinetics, vol.19,  *
*                                   p.799 (1987).                    *
*                                                                    *
*   USAGE           - CALL RABSOH(TBOND,TGROUP,IG,RATE,TACT)         *
*                                                                    *
*   ARGUMENTS  TBOND - bond-matrix of reacted -C-H-  (input)         *
*              TGROUP- functional groups of -C-H-    (input)         *
*              IG    - number of group with C-H bond (input)         *
*              RATE  - reaction rate constant 298 K  (output)        *
*              TACT  - activation energy             (output)        *
*                                                                    *
*   Find initial reaction rate for the group involved in the reaction*
*   and activation temperatures near 298K:                           *
*                Tact = E/R = B/R + nT                               *
*   Activation temperatures are estimated from the rate constant     *
*   function:                                                        *
*                k = A T**2 exp(-B/T) exp(Ex/T)                      *
*   where Ex is from substituent groups.                             *
*   Then, near 298K:                                                 *
*                Tact = B - Ex + 2*298. = B - Ex + 596               *
*                                                                    *
*    INCLUDE    general.h includes all information about global      *
*                         variables: MCA and functional groups.      *
*                                                                    *
*    DATA BLOCK     SNAME = RABSOH                                   *
*                                                                    *
*    LOCAL VARIABLES...                                              *
*                                                                    *
*     MULTI     multiplicator for Rate in case of alpha- and/or beta *
*               substituents for -CH3                                *
*     TDIF      activation temperature addition in case of alpha-    *
*               and/or beta- substituents for -CH3                   *
*     I, J      DO-LOOP indexes                                      *
*                                                                    *
**********************************************************************
      SUBROUTINE rabsisom(tbond,tgroup,ig,ar1,ar2,ar3)
      IMPLICIT NONE
      INCLUDE 'general.h'
      INCLUDE 'organic.h'
      INCLUDE 'common.h'

* input
      INTEGER         tbond(mca,mca)
      CHARACTER(LEN=lgr) tgroup(mca)
      INTEGER         ig

* output
      REAL   ar1,ar2,ar3

* internal:
      INTEGER      i,j
      REAL         mult

      IF(wtflag.GT.0) WRITE(6,*) "*rabsisom*"
* initialize rate = 0
      ar1 = 0.
      ar2 = 0.
      ar3 = 0.

* check ig value is ok
      IF (ig.GT.mca) then
         WRITE(6,*) '--error--, in rabsisom'
         WRITE(6,*) ' => ig is greater than mca'
         STOP
      ENDIF

* find k(0) value:
* Except when noted, value are from Carter 1999 and are described
* in the SAPRC99 documentation.
* UPDATE from Atkinson 2007 (ric)
      IF (tgroup(ig)(1:3).EQ.'CH3') THEN
        ar1 = 1.2E11
        ar2 = 0.
        ar3 = 3825.
      ELSE IF(tgroup(ig)(1:3).EQ.'CH2') THEN
        ar1 = 8.0E10
        ar2 = 0
        ar3 = 3010
      ELSE IF(tgroup(ig)(1:3).EQ.aldehyde) THEN
        ar1 = 0.8E11
        ar2 = 0.
        ar3 = 2890
      ELSE IF(tgroup(ig)(1:2).EQ.'CH') THEN
        ar1 = 4.0E10
        ar2 = 0.
        ar3 = 2440
      ELSE
        WRITE(6,'(a)') '--error--'
        WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE : rabsisom'
        WRITE(6,'(a)') 'group not allowed to react by isomerisation'
        WRITE(6,'(a)') tgroup(ig)
        STOP
      ENDIF

* find multipliers of reaction rates, based on substituents:
* multipliers are the same than the one for the OH reaction but
* at the power 1.5
* UPDATE from Atkinson 2007 F(X)isom = F(X)OH^1.3

* on same carbon:
      mult = 1.
      IF (INDEX(tgroup(ig),hydroxy).NE.0) THEN
         mult = 3.50
         ar3=ar3-298.*1.3*log(mult)
      ENDIF
      IF (INDEX(tgroup(ig),nitrate).NE.0) THEN
         mult = 0.04
         ar3=ar3-298.*1.3*log(mult)
      ENDIF
* group contribution for -OOH is based following the comparaison
* between rate constant for CH3OOH+OH -> CH2OOH and the rate
* constant provided by Kwok for the CH3 group. This lead to
* a factor 13 for the -OOH group at 298 K. On the other hand,
* comparaison between the rate constant for the CH3OH+OH -> CH2OH
* provide a group contribution for -OH of 5.9 while the value
* given by Kwok is only 3.5. On that basis, the group factor for
* the -OOH group was lowered by the same factor (i.e 1.7) leading
* finally to F(-OOH) = 7.6. 
      IF(INDEX(tgroup(ig),hydro_peroxide) .NE. 0) THEN
         mult = 7.6
         ar3=ar3-298.*1.3*log(mult)
      ENDIF

* on alpha carbons:
      DO 10 i=1,mca
        mult = 1.
        IF (tbond(ig,i).NE.0) THEN
* simple alkyl:
          IF (tgroup(i)(1:3).EQ.methyl) THEN
            mult =  1.
            ar3=ar3-298.*1.3*log(mult)
          ENDIF
          IF(tgroup(i)(1:4) .EQ. 'CH2 ') THEN
            mult =  1.23
            ar3=ar3-298.*1.3*log(mult)
          ENDIF
          IF(tgroup(i)(1:4) .EQ. 'CH2(') THEN
            mult =  1.23
            ar3=ar3-298.*1.3*log(mult)
          ENDIF
          IF(tgroup(i)(1:3) .EQ. 'CH ' ) THEN
            mult =  1.23
            ar3=ar3-298.*1.3*log(mult)
          ENDIF
          IF(tgroup(i)(1:3) .EQ. 'CH(' ) THEN
            mult =  1.23
            ar3=ar3-298.*1.3*log(mult)
          ENDIF
          IF(tgroup(i)(1:2) .EQ. 'C('  ) THEN
            mult =  1.23
            ar3=ar3-298.*1.3*log(mult)
          ENDIF
          IF(tgroup(i)(1:2) .EQ. 'C '  ) THEN
            mult =  1.23
            ar3=ar3-298.*1.3*log(mult)
          ENDIF

* overwrite for carbonyls, carboxylic acid and PAN values 
          IF (tgroup(i)(1:2).EQ.carbonyl) THEN
            mult =  0.75
            ar3=ar3-298.*1.3*log(mult)
          ENDIF
          IF (tgroup(i)(1:3).EQ.aldehyde) THEN
            mult =  0.75
            ar3=ar3-298.*1.3*log(mult)
          ENDIF
          IF (tgroup(i)(1:7).EQ.carboxylic_acid) THEN
            mult =  0.74
            ar3=ar3-298.*1.3*log(mult)
          ENDIF
          IF (INDEX(tgroup(i),nitrate).NE.0) THEN
            mult =  0.20
            ar3=ar3-298.*1.3*log(mult)
          ENDIF
* For PAN, koh is close to the rate constant for CH3 (respectively
* 1.1E-13 and 1.36E-13). Therefore group factor for PAN was set to 1.
          IF (tgroup(i)(1:10).EQ.pan) THEN
            mult =  1.00
            ar3=ar3-298.*1.3*log(mult)
          ENDIF

* on beta carbons: for -CH2CO-, use MULT = 3.9. Group contribution
* taken above for the CH2 or CH group must be removed. 
          IF (mult.EQ.1.23) THEN
            DO j=1,mca
              IF (tbond(i,j).NE.0 .AND. j.NE.ig) THEN
                 IF (tgroup(j)(1:2).EQ.carbonyl) THEN
                   mult =  3.9
                   ar3=ar3-298.*log(mult)+298.*1.3*log(1.23)
                 ENDIF
                 IF (tgroup(j)(1:3).EQ.aldehyde ) THEN
                   mult =  3.9
                   ar3=ar3-298.*log(mult)+298.*1.3*log(1.23)
                 ENDIF
              ENDIF
            ENDDO
          ENDIF

        ENDIF
10    CONTINUE

* end of rabsisom
      RETURN
      END

