***************************************************************************
* Based on Multip, but treats only ONE group: the substituted end of a di-
* radical formed in ring-opening 
***************************************************************************
      SUBROUTINE oprad(gold,gnew,tcop)
      IMPLICIT NONE
      INCLUDE 'general.h'
      INCLUDE 'organic.h'
      INCLUDE 'common.h'

* input
      CHARACTER(LEN=lgr) gold
* output
      CHARACTER(LEN=lgr) gnew
      CHARACTER(LEN=lco) tcop

* internal variables:
      CHARACTER(LEN=lgr)  pold, pnew
      
      IF (wtflag.NE.0) WRITE(6,*)'*oprad*'
      !print*,gold
         
* initialize:
      gnew = ' '
      tcop = ' '

* ----------------------------------------
* OPTIONS FROM SUBROUTINE MULTIP
* ----------------------------------------
* radical on double-TBOND carbon TGROUP     : not likely in openr
* ----------------------------------------
* radical on alkyl carbon : criegge         : not likely in openr
* ----------------------------------------
* radical on alkyl carbon : di-radical      : not likely in openr
* ----------------------------------------
* radical on carbonyl-carbon TGROUP         : deal with later in openr
* ----------------------------------------
* radical on alkyl carbon : primary alkyl   : deal with later in openr
* ----------------------------------------
* radical on alkyl carbon : secondary alkyl : allow decomposition
* -----------------------------------------
* CH(OOH).  / CH(OH).  / CH(ONO2). -> CHO

      IF (INDEX(gold,secondary).NE.0) THEN

         IF (INDEX(gold,hydro_peroxide).NE.0) THEN
            gnew = aldehyde
            tcop = 'HO   '
         ELSE IF (INDEX(gold,hydroxy).NE.0) THEN
            gnew = aldehyde
            tcop = 'HO2  '
         ELSE IF (INDEX(gold,nitrate).NE.0) THEN
            gnew = aldehyde
            tcop = 'NO2  '
         ELSE IF ( (INDEX(gold,hydro_peroxide).EQ.0) .AND.
     +             (INDEX(gold,hydroxy).EQ.0) .AND.
     +             (INDEX(gold,nitrate).EQ.0) ) THEN
            print*,"ERROR: subroutine oprad invoked for group"
            print*,gold
            STOP
         ENDIF         

* -----------------------------------------
* radical on alkyl carbon : tertiary alkyl  : allow decomposition
* -----------------------------------------
* C(OOH)(R).  / C(OH)(R).  / C(ONO2)(R). -> CO(R)

      ELSE IF ( (INDEX(gold,'Cd'    ).EQ.0) .AND.
     &          (INDEX(gold,'CO'    ).EQ.0) .AND.
     &          (INDEX(gold,'.(OO.)').EQ.0) .AND.
     &          (INDEX(gold,'..'    ).EQ.0) .AND.
     &          (INDEX(gold,'CH'    ).EQ.0) ) THEN

         IF (INDEX(gold,hydro_peroxide).NE.0) THEN
            pold = '.'
            pnew = ' '
            CALL swap(gold,pold,gnew,pnew)
            gold = gnew
            pold = 'C'
            pnew = carbonyl
            CALL swap(gold,pold,gnew,pnew)
            gold = gnew
            pold = hydro_peroxide
            pnew = ' '
            CALL swap(gold,pold,gnew,pnew)
            gold = gnew
            tcop = 'HO   '
         ELSE IF (INDEX(gold,hydroxy).NE.0) THEN
            pold = '.'
            pnew = ' '
            CALL swap(gold,pold,gnew,pnew)
            gold = gnew
            pold = 'C'
            pnew = carbonyl
            CALL swap(gold,pold,gnew,pnew)
            gold = gnew
            pold = hydroxy
            pnew = ' '
            CALL swap(gold,pold,gnew,pnew)
            gold = gnew
            tcop = 'HO2  '
         ELSE IF (INDEX(gold,nitrate).NE.0) THEN
            pold = '.'
            pnew = ' '
            CALL swap(gold,pold,gnew,pnew)
            gold = gnew
            pold = 'C'
            pnew = carbonyl
            CALL swap(gold,pold,gnew,pnew)
            gold = gnew
            pold = '(ONO2)'      
            pnew = ' '
            CALL swap(gold,pold,gnew,pnew)
            gold = gnew
            tcop = 'NO2  '
         ELSE
            print*,"ERROR: subroutine oprad invoked for group"
            print*,gold
            STOP
         ENDIF
      ENDIF 

      RETURN
      END
