************************************************************************
* MASTER MECHANISM - ROUTINE NAME : onum                               *
*                                                                      *
* PURPOSE: Counting number of C-O-C in a molecule                      *
*                                                                      *
* CREATED: Julia Lee-Taylor, NCAR                                      *
*                                                                      *
* INPUT:                                                               *
* - chem         : chemical formula                                    *
*                                                                      *
* OUTPUT:                                                              *
* - nc           : number of carbon in formula                         *
*                                                                      *
************************************************************************
      INTEGER FUNCTION onum(chem,nc)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input
      CHARACTER(LEN=lfo) chem
      INTEGER         nc

* internal:
      INTEGER io, i

* initialize:
      onum = 0
      io   = 0

* count ether:
      DO i=1,nc
        IF (chem(i:i+1).EQ.'-O') io=io+1
      ENDDO
      onum = io

* end of onum
      RETURN
      END
