!***********************************************************************
! This subroutine count the number of ortho nitro-phenols group in
! a molecule
!***********************************************************************
      SUBROUTINE nitrofol(ng,group,bond,onitrofol)
      IMPLICIT NONE
      INCLUDE 'general.h'
      
! input 
      INTEGER         ng
      CHARACTER(LEN=lgr) group(mca)
      INTEGER         bond(mca,mca)

! output
      INTEGER onitrofol
      
! local
      INTEGER tempoh16
      INTEGER i,k,l

! initialize
      onitrofol=0

! start loop - only the H of the hydroxy group (whether
! alkohol or carboxylic) is seek of H bonding
      DO 234 i=1,ng
        IF (INDEX(group(i),'(OH)').ne.0) THEN  ! OPEN 'OH'
          IF (INDEX(group(i),'CO(OH)').ne.0) GOTO 234 ! EXCLUDE ACID H 
          IF (group(i)(1:1).NE.'c') GOTO 234 ! EXCLUDE non aromatic OH
              tempoh16=0     ! a phenol is found

! search for nitro group on the alpha carbon
            DO 732 k=1,ng
              IF (group(k)(1:1).NE.'c') GOTO 732 ! EXCLUDE non aromatic groups
                IF (bond(i,k).ne.0) THEN
                  IF (INDEX(group(k),'(NO2)').NE.0) THEN
                   tempoh16=tempoh16+1
                  ENDIF
                ENDIF
732         CONTINUE

! increment is maximum 1 per OH (a given OH can only be involded in a
! single bond)
           IF (tempoh16.gt.0) THEN
              onitrofol=onitrofol+1
           ENDIF
        ENDIF   ! CLOSE 'OH'
234   CONTINUE

! return
      END
