************************************************************************
* MASTER MECHANISM - ROUTINE NAME  loader                              *
*                                                                      *
* PURPOSE: Load or unload molecules in the stack for further reaction  *
*          Two stacks are considered, one for the non radical VOC      *
*          molecule and one for the radical molecule. Reactions for    *
*          radical are written first (see main.f)                      *
*                                                                      *
* If updn > 0  then load holder stack with new species (chem)          *
* If updn = -1 then shift down stack (reaction for species chem has    *
*              been written                                            *
*                                                                      *
* Information loaded in the stack is :                                 *
*   - holdvoc(1:6) = short name of the chemical                        *
*   - holdvoc(7:126) = chemical formula                                *
*   - holdvoc(127:129) = number of generation (through stable          *
*                        molecule only) necessary to produce chem      *
*   - holdvoc(130:132) = number of level (including radicals)          *
*                        necessary to produce chem                     *
*                                                                      *
* INPUT:                                                               *
*  - updn        : used to tell whether the species must be added      *
*                  in the stack (>0) or removed from the stack (-1)    *
*  - chem        : formula of the species that must added (or remove)  *
*                  in the stack                                        *
*  - name        : short name for species that must added (or remove)  *
*                  in the stack                                        *
*  - level       : number of level (stable + radicals) that were       *
*                  necessary to produce "chem"                         *
*  - stabl       : number of stable level (no radical) that were       *
*                  necessary to produce "chem"                         *
*                                                                      *
* INPUT/OUTPUT:                                                        *
*  - nhldvoc     : number of (stable) VOC in the stack                 *
*  - holdvoc(i)  : liste of the VOC in the stack (see information      *
*                  above)                                              *
*  - nhldrad     : number of radical in the stack                      *
*  - holdrad(i)  : liste of the radicals in the stack (see information *
*                  above)                                              *
************************************************************************
      SUBROUTINE loader(updn,chem,name,
     &                  level,stabl,nhldvoc,holdvoc,nhldrad,holdrad)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input:
      INTEGER         updn
      CHARACTER(LEN=lfo) chem
      CHARACTER(LEN=lco) name
      
* input/output
      INTEGER         level
      INTEGER         stabl
      CHARACTER(LEN=lst) holdvoc(mlv)
      INTEGER         nhldvoc
      CHARACTER(LEN=lst) holdrad(mra)
      INTEGER         nhldrad

* local
      CHARACTER(LEN=lcf) rdct
      INTEGER         i

* --------------------------------------------
* initialize
* --------------------------------------------

      rdct = ' '

* --------------------------------------------
* LOAD SPECIES IN THE STACK (UPDN > 0)
* --------------------------------------------

      IF (updn.GE.1) THEN

* update counters:
        WRITE(rdct,'(a6,a120)') name,chem

* VOC (non radical) species
* --------------------------
        IF (INDEX(rdct,'#') .NE. 0) THEN
          nhldvoc = nhldvoc + 1
          IF (nhldvoc.GE.mlv) THEN
            WRITE(*,*) '--error--, in loader'
            WRITE(*,*) 'number of voc species in the stack'
            WRITE(*,*) 'exceed the size of the table(mlv)'
            WRITE(*,*) 'nhldvoc=',nhldvoc
            STOP
          ENDIF

          WRITE(holdvoc(nhldvoc),'(a126,i3,i3)') rdct,stabl,level
        
        ELSE IF (INDEX(rdct,'.') .EQ. 0) THEN
          nhldvoc = nhldvoc + 1
          IF (nhldvoc.GE.mlv) THEN
            WRITE(*,*) '--error--, in loader'
            WRITE(*,*) 'number of voc species in the stack'
            WRITE(*,*) 'exceed the size of the table(mlv)'
            WRITE(*,*) 'nhldvoc=',nhldvoc
            STOP
          ENDIF

          WRITE(holdvoc(nhldvoc),'(a126,i3,i3)') rdct,stabl,level
      
* radical species
* ---------------
        ELSE
          nhldrad = nhldrad + 1
          IF (nhldrad.GE.mra) THEN
            WRITE(*,*) '--error--, in loader'
            WRITE(*,*) 'number of radical species in the stack'
            WRITE(*,*) 'exceed the size of the table(mra)'
            WRITE(*,*) 'nhldrad=',nhldrad
            STOP
          ENDIF
          WRITE(holdrad(nhldrad),'(a126,i3,i3)') rdct,stabl,level
        ENDIF

* --------------------------------------------
* REMOVE THE SPECIES FROM THE STACK (UPDW=-1)
* --------------------------------------------

* FOLLOWING NOT USED ANYMORE - DONE DIRECTLY IN MAIN
C      ELSE IF (updn.EQ.-1) THEN
C         IF (INDEX(chem,'.').EQ.0) THEN
C           DO i=1,nhldvoc + 1
C             holdvoc(i)  = holdvoc(i+1)
C           ENDDO
C           nhldvoc = nhldvoc - 1
C         ELSE
C           DO i=1,nhldrad + 1
C             holdrad(i)  = holdrad(i+1)
C           ENDDO
C           nhldrad = nhldrad - 1
C         ENDIF                                          

* --------------------------------------------
* UPDN NOT PROPERLY SET
* --------------------------------------------

      ELSE
        WRITE(6,'(a)') '--error--'
        WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE : loader'
        WRITE(6,'(a)') 'false argument value, UPDN incorrect:'
        WRITE(6,'(a)') chem
        STOP
      ENDIF

      RETURN
      END
