! Remove the path that would lead to count the ester twice. 
! Performed by "killing" the "second" node of the functionality.
!
! tabester : provide the position of ester "couple" (i.e
!            the O and CO nodes. For example, the molecule
!            CH3CO-O-CH2-O-COCH3 has the following values
!            tabester(1,1)=3,tabester(1,2)=2 
!            tabester(2,1)=5,tabester(2,2)=6
!
! - nabcde(k)    : number of distinct pathways that end up at a        
!                  position k relative to top (e.g. nabcde(3) gives    
!                  the number of distinct pathways finishing in a      
!                  beta position relative to top                        
! - tabcde(k,i,j) : give the pathways (node j), for the track number i  
!                   to reach the position k (k=2 is beta position ...).
!                   For example, tabcde(4,1,j) give the first track to 
!                   reach a gamma position (node given by                  
!                   tabcde(4,1,4), using the track given by            
!                   tabcde(4,1,*)                                      
! ----------------------------------------------------------------------
      SUBROUTINE kill_ester(tabester,nabcde,tabcde)
      IMPLICIT NONE
      INCLUDE 'general.h'

! input
      INTEGER nabcde(9)
      INTEGER tabester(4,2)  ! 1= -O- side, 2= CO side
! input/output
      INTEGER tabcde(9,mco,mca)

! local
      INTEGER k, ipos, it, j

      DO k=1,4
        IF (tabester(k,1).ne.0) THEN

          DO ipos=2,9
            DO it=1,nabcde(ipos)
              DO j=1,ipos-1

                IF (tabcde(ipos,it,j).eq.tabester(k,1)) THEN
                  IF (tabcde(ipos,it,j+1).eq.tabester(k,2)) THEN
                    tabcde(ipos,it,j+1)=0  ! set the node to 0
                  ENDIF 
                ENDIF 

                IF (tabcde(ipos,it,j).eq.tabester(k,2)) THEN
                  IF (tabcde(ipos,it,j+1).eq.tabester(k,1)) THEN
                    tabcde(ipos,it,j+1)=0  ! set the node to 0
                  ENDIF 
                ENDIF 

              ENDDO
            ENDDO
          ENDDO

        ENDIF
      ENDDO

      END