***************************************************************************
* SUBROUTINE ISOM16                                                       *
*                                                                         *
* this subroutine performs a 1-6 isomerisation in the case of the a pinene*
* ozonolysis to produce a dicarboxylic acid (pinic acid)                  *
*                                                                         *
* INPUT  : -chem                                                          *
*                                                                         *
* OUTPUT : -tchem(mca) : formula of the different species.                *
*          -nchem : number of different species.                          *
*                                                                         *
***************************************************************************

      SUBROUTINE isom16(chem,tchem,nchem,sc)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input
      CHARACTER(LEN=lfo)  chem

* output
      CHARACTER(LEN=lfo)  tchem(mca)
      INTEGER          nchem
      REAL             sc(mca)

*internal
      INTEGER          i,j,ia,nring,dbflg
      INTEGER          nc,nca
      CHARACTER(LEN=lgr)  group(mca)
      INTEGER          bond(mca,mca)
      INTEGER          rjg(mri,2)
      INTEGER          track(mco,mca)
      INTEGER          trlen(mco)
      INTEGER          ntr

* initialize:
      nca = 0
      ia=0
      DO i=1,mco
        trlen(i)=0
        DO j=1,mca
          track(i,j)=0
        ENDDO
      ENDDO
      ntr=0

* find groups and bond matrix from chem      
      nc = INDEX(chem,' ') - 1
      CALL grbond(chem,nc,group,bond,dbflg,nring)
      IF (nring.GT.0) CALL rjgrm(nring,group,rjg)

      DO i=1,mca
        IF (group(i)(1:1).NE.' ') THEN
          nca=nca+1
        ENDIF
      ENDDO

* find group which contains '.' (if none, escape)
      DO i=1,nca
        IF (INDEX(group(i),'O.').NE.0) ia = i
      ENDDO
      IF (ia.EQ.0) RETURN

      CALL gettrack(bond,ia,nca,ntr,track,trlen)
* 1,7H shift 
      DO 130 i=1,ntr
        IF (trlen(i).LT.6) GOTO 130
        IF (INDEX(chem,'OH').NE.0) GOTO 130
        IF (INDEX(chem,'N').NE.0) GOTO 130
        IF (INDEX(chem,'(CHO)').NE.0) GOTO 130
        IF (INDEX(chem,'COC').NE.0) GOTO 130
        IF (INDEX(chem,'Cd').NE.0) GOTO 130

        IF ((INDEX(chem,'CO(O.)').NE.0).AND.
     &      (group(track(i,6)).EQ.'CHO').AND.
     &       (nring.NE.0)) THEN
          WRITE(15,*) '1,7H shift = ',chem(1:50)

          group(ia) = 'CO(OH)'
          group(track(i,6)) = 'CO.'
          CALL rebond(bond,group,tchem(1),nring)
	  sc(1) = 0.8
	  tchem(2) = chem
	  sc(2) = 0.2
          nchem = 2  
          RETURN   
	ENDIF

130   CONTINUE

* 1,8H shift 
      DO 140 i=1,ntr
        IF (trlen(i).LT.7) GOTO 140
        IF (INDEX(chem,'OH').NE.0) GOTO 140
        IF (INDEX(chem,'(CHO)').NE.0) GOTO 140
        IF (INDEX(chem,'N').NE.0) GOTO 140
        IF (INDEX(chem,'Cd').NE.0) GOTO 140

        DO j=1,nca
        IF ((bond(ia,j).NE.0).AND.(group(j).EQ.'CO').AND.
     &      (group(ia).EQ.'CH2(O.)').AND.
     &      (group(track(i,7)).EQ.'CHO').AND.
     &       (nring.NE.0)) THEN
          WRITE(15,*) '1,8H shift = ',chem(1:50)

          group(ia) = 'CH2(OH)'
          group(track(i,7)) = 'CO.'
          CALL rebond(bond,group,tchem(1),nring)
	  sc(1) = 0.2
	  tchem(2) = chem
	  sc(2) = 0.8
          nchem = 2
          RETURN   
	ENDIF
        ENDDO

140   CONTINUE

      END
      
