************************************************************************
* MASTER MECHANISM - ROUTINE NAME : getbrch                            *
*                                                                      *
*                                                                      *
* PURPOSE:  write the branch starting at the position ia (alpha        *
*           position) and bounded to the position ig. One of the beta  *
*           positions is known (ib). The various ways of writing the   *
*           branch are checked => A standard "formula" of the chain    *
*           is given as output                                         *
*                                                                      *
* The structure of the subroutine is :                                 *
* 1- find longest trees starting from ia                               *
* 2- write for each tree a copy of the corresponding formula           *
* 3- find which formula has the highest priority                       *
*                                                                      *
* INPUT:                                                               *
* - lobond(i,j)  : logical carbon-carbon bond matrix                   *
* - group(i)     : group at position (carbon) i                        *
* - rank(i)      : rank (priority) of group i (low = more important)   *
* - ig           : group number to which the branch is bounded         *
* - ia           : group number where the branch begin (alpha position *
*                  with recpect to the cabon ig)                       *
* - ib           : group bounded to ia (beta position with respect to  *
*                  the cabon ig                                        *
* - nca          : total number of group in the molecule               *
*                                                                      *
* OUTPUT:                                                              *
* - brch         : "full" standardized formula of the branch           *
* - ml           : length of the branch                                *
*                                                                      *
************************************************************************
      SUBROUTINE getbrch(lobond,group,nca,rank,nring,ig,ia,ib,brch,ml)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input
      LOGICAL         lobond(mca,mca)
      CHARACTER(LEN=lgr) group(mca)
      INTEGER         nca,nring,ig,ia,ib
      INTEGER         rank(mca)

* output:
      CHARACTER(LEN=lfo) brch
      INTEGER         ml

* internal:
      INTEGER np,tnp,maxpri,ptra
      INTEGER iadd,pre,nex
      INTEGER brpath(mca,mca)
      CHARACTER(LEN=lfo) brcopy(mca), tbrcopy(mca)
      INTEGER i,j

      !print*,'*getbrch*'
* initialize
* ----------
      brch=' '
      ml=0

* search the longest tree, starting from ia
* -----------------------------------------
      lobond(ia,ig)=.false.
      lobond(ig,ia)=.false.
      CALL treebr(lobond,ig,ia,ib,nca,brpath,ml,np)
      lobond(ia,ig)=.true.
      lobond(ig,ia)=.true.

* write copy of longest branch
* ----------------------------
      DO i=1,np
        ptra=1
        brcopy(i)=' '
        DO j=1,ml
          iadd=brpath(i,j)
          IF (j.eq.1) THEN
             pre = ig
          ELSE
             pre = brpath(i,j-1)
          ENDIF
          nex = brpath(i,j+1)
          CALL mkbrcopy(lobond,group,nca,rank,
     &                  iadd,pre,nex,ptra,brcopy(i))
        ENDDO
      ENDDO

* If only 1 chain : write out and return
* ---------------------------------------

      IF (np.eq.1) THEN
        brch=brcopy(1)
        RETURN
      ENDIF

* if more than 1 chain : get the chain with the highest priority
* --------------------------------------------------------------

* collapse identical copy
      DO i=1,np-1
        DO j=i+1,np
          IF (brcopy(i).eq.brcopy(j)) brcopy(j)=' '
        ENDDO
      ENDDO

      tnp=np
      np=0
      DO i=1,tnp
        IF (brcopy(i)(1:1).NE.' ') THEN
          np=np+1
          tbrcopy(np)=brcopy(i)
        ENDIF
      ENDDO

* if only 1 chain remain then write out and return else search priority
      IF (np.eq.1) THEN
        brch=tbrcopy(1)
        RETURN
      ELSE
        CALL brpri(group,rank,tbrcopy,np,nring,maxpri)
        brch=tbrcopy(maxpri)
        RETURN
      ENDIF

      END
