      SUBROUTINE gas2wall(lrea,chem,name,Tb,dB,mweight)
      INCLUDE 'general.h'

      CHARACTER(LEN=lfo),INTENT(in) :: chem
      CHARACTER(LEN=lco),INTENT(in) :: name
      INTEGER,INTENT(in)         :: lrea
      REAL,INTENT(in)            :: Tb,dB
      REAL,INTENT(in)            :: mweight

      CHARACTER*1     :: a1,a2,a3,a4
      CHARACTER(LEN=lco) :: r(3), p(mnp), namlst(mni)
      REAL            :: s(mnp),ar1,ar2,ar3,f298,fratio
      INTEGER         :: idreac, nlab
      REAL            :: xlab,folow(3),fotroe(4)
      REAL            :: auxinfo(9)
      CHARACTER*1     :: charfrom,charto


! initialize (most not used here)
      CALL rxinit3(a1,a2,a3,a4,r,s,p,ar1,ar2,ar3,
     &             f298,fratio,idreac,nlab,xlab,folow,fotroe)
      auxinfo(:)=0.


! ---- from gas to wall
      r(1)= name
      p(1)= name
      s(1) = 1.
      r(2)= 'WIN '
      ar1 = 1.111E-3 ! measures 2-ketones Matsunaga et al.2010 AST
      ar2 = 0.
      ar3 = 0.
      idreac=3
      charfrom='G'
      charto='W'
      auxinfo(1)=Tb
      auxinfo(2)=dB
      IF (INDEX(chem,'O').EQ.0) THEN
        auxinfo(3)=2.E-5  ! measures 1-alkenes Matsunaga et al.2010 AST
      ELSE
        auxinfo(3)=1.2E-4 ! measures 2-ketones Matsunaga et al.2010 AST
      ENDIF
      CALL rxwrit_dyn(lrea,r,s,p,ar1,ar2,ar3,
     &                idreac,auxinfo,charfrom,charto)

! ---- from wall to gas
      r(1)= name
      p(1)= name
      s(1) = 1.
      r(2)= 'WOU '
      ar1 = 1.111E-3  ! s-1
      ar2 = 0.
      ar3 = 0.
      idreac=4
      charfrom='W'
      charto='G'
      auxinfo(1)=Tb
      auxinfo(2)=dB
      IF (INDEX(chem,'O').EQ.0) THEN
        auxinfo(3)=2.E-5  ! measures 1-alkenes Matsunaga et al.2010 AST
      ELSE
        auxinfo(3)=1.2E-4 ! measures 2-ketones Matsunaga et al.2010 AST
      ENDIF
      CALL rxwrit_dyn(lrea,r,s,p,ar1,ar2,ar3,
     &                idreac,auxinfo,charfrom,charto)

      END
