************************************************************************
* MASTER MECHANISM - ROUTINE NAME :      dwrite                        *
*                                                                      *
*                                                                      *
* PURPOSE :  Add "=" to copies with double bonds                       *
*                                                                      *
* INPUT/OUTPUT :                                                       *
*  - cp           : chemical formula in which '=' is added             *
************************************************************************
      SUBROUTINE dwrite(cp)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input/output:
      CHARACTER(LEN=lfo) cp

* internal:
      CHARACTER(LEN=lfo) tempkc
      INTEGER         nc,idb,l,i,p,idp,ncd,j,ibflg,n,start,start2

* initialize
      tempkc = ' '
      l   = 0
      idb = 0
      nc  = INDEX(cp,' ') - 1
      idp=0
      p=0

* write "=" and reset IDB if not CdCdCd:
c      DO i=1,nc
c	IF(cp(i:i+1).EQ.'Cd') THEN 
c          idb = idb + 1        
c          IF (idb.GT.1) THEN
c           l = l + 1
c            tempkc(l:l) = '='
c            IF (cp(i+2:i+3).NE.'Cd') idb = 0
c          ENDIF
c        ENDIF
! Ludo: since the change in lntree routine, the double bond aren't automatically
! in the longest path. It's now possible to have a doule bond as a branch
      DO i=1,nc
! Ludo: Find the end of the branch after Cd
        IF (idp.NE.0) THEN
           IF (cp(i:i).EQ.'(') THEN
              p = p+1
           ELSE IF (cp(i:i).EQ.')') THEN
              p = p-1
           ENDIF
           IF (p.EQ.1) start2 = 1
        ENDIF
	IF(cp(i:i+1).EQ.'Cd') THEN
          IF (((cp(i+2:i+2).EQ.'(').OR.(cp(i+3:i+3).EQ.'('))
     &       .AND.(idb.EQ.0)) THEN
! Ludo: check if there's a double bond in the branch.
            ncd = 0
            ibflg=0
            n=0
            start = 0
            DO j=i+2,nc
              IF (cp(j:j).EQ.'(') THEN
                n = n+1
              ELSE IF (cp(j:j).EQ.')') THEN
                n = n-1
              ENDIF
              IF (n.EQ.1) start = 1
              IF ((cp(j:j+1).EQ.'Cd').AND.(ibflg.EQ.0)) THEN
                 ncd = ncd+1
              ENDIF
              IF ((n.EQ.0).AND.(ibflg.EQ.0).AND.(start.EQ.1)) THEN
                ibflg=1
                IF (ncd.EQ.2) THEN
                  idp = idp + 1
                  ncd = 0
                ELSE
                  idb = idb + 1
                  ncd = 0
                ENDIF
              ENDIF
            ENDDO             
          ELSE
             idb = idb + 1
          ENDIF       
          IF ((idp.EQ.1).AND.(p.EQ.0).AND.(start2.EQ.1)) THEN
            l = l + 1
            tempkc(l:l) = '='
            idp = 0
            start2 = 0
          ELSE IF (idb.GT.1) THEN
            l = l + 1
            tempkc(l:l) = '='
            IF (cp(i+2:i+3).NE.'Cd') idb = 0
          ENDIF
        ENDIF
* normal write:
        l = l + 1
        tempkc(l:l) = cp(i:i)
      ENDDO

* exit if formula is longer than lfo:
      IF (l.GT.lfo) THEN
        WRITE(6,'(a)') '--error--'
        WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE : dwrite'
        WRITE(6,'(a)') 'chemical formula is too long:'
        WRITE(6,'(a)') cp
        STOP
      ENDIF

* write-out formula and return:
      cp = tempkc
      RETURN
      END
