************************************************************************
* MASTER MECHANISM - ROUTINE NAME : cnum                               *
*                                                                      *
*                                                                      *
* PURPOSE: Counting number of carbons in a molecule                    *
*                                                                      *
* INPUT:                                                               *
* - chem         : chemical formula                                    *
*                                                                      *
* OUTPUT:                                                              *
* - nc           : number of nodes (carbons or -O-) in formula         *
*                                                                      *
************************************************************************
      INTEGER FUNCTION cnum(chem,nc)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input
      CHARACTER(LEN=lfo) chem
      INTEGER         nc

* internal:
      INTEGER ic, i

* initialize:
      cnum = 0
      ic   = 0

* count carbons:
!* count nodes:
      DO i=1,nc
        IF((chem(i:i).EQ.'C'.AND.chem(i:i+1).NE.'Cl')
c     &  .OR.(chem(i:i).EQ.'c'.AND.chem(1:1).NE.'#')) ic=ic+1
     &  .OR.(chem(i:i).EQ.'c')) ic=ic+1
      ENDDO
      cnum = ic

* end of cnum
      RETURN
      END
